% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Exact_multinomial_test_1xc.R
\name{Exact_multinomial_test_1xc}
\alias{Exact_multinomial_test_1xc}
\title{The exact multinomial test for multinomial probabilities}
\usage{
Exact_multinomial_test_1xc(n, pi0, printresults = TRUE)
}
\arguments{
\item{n}{the observed counts (a 1xc vector, where c is the number of categories)}

\item{pi0}{given probabilities (a 1xc vector)}

\item{printresults}{display results (F = no, T = yes)}
}
\value{
probability value
}
\description{
The exact multinomial test for multinomial probabilities

Described in Chapter 3 "The 1xc Table and the Multinomial Distribution"
}
\examples{
# Genotype counts for SNP rs 6498169 in RA patients
\dontrun{
Exact_multinomial_test_1xc(n = c(276, 380, 118), pi0 = c(0.402, 0.479, 0.119))
}
# subset of 10 patients
Exact_multinomial_test_1xc(n = c(6, 1, 3), pi0 = c(0.402, 0.479, 0.119))
}
