% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{Plot}
\alias{Plot}
\alias{average}
\alias{optimal}
\alias{arms}
\alias{do_plot}
\alias{gg_color_hue}
\alias{check_history_data}
\title{Plot}
\description{
Generates plots from \code{\link{History}} data.
}
\details{
Usually not instantiated directly but invoked by calling the generic \code{plot(h)}, where \code{h}
is an \code{\link{History}} class instance.
}
\section{Usage}{

\preformatted{
   Plot <- Plot$new()
}
}

\section{Methods}{


\describe{

\item{\code{cumulative(history,...)}}{
Plots cumulative regret or reward (depending on parameter regret=TRUE/FALSE) over time.
}
\item{\code{average(history,...)}}{
Plots average regret or reward (depending on parameter regret=TRUE/FALSE) over time.
}
\item{\code{arms(history),...}}{
Plot the percentage of simulations per time step each arm was chosen over time.
If multiple agents have been run, plots only the first agent.
}
}
}

\section{Plot method arguments}{


\describe{
\item{\code{type}}{
\code{(character, "cumulative")} Can be either "cumulative" (default), "average", or "arms".
Sets the plot method when Plot() is called through R's generic plot() function.
Methods are descrived in the Methods section above.
}
\item{\code{regret}}{
\code{(logical, TRUE)} Plot policy regret (default, TRUE) or reward (FALSE)?
}
\item{\code{rate}}{
(\code{logical, TRUE)} If rate is TRUE, the rate of regret or reward is plotted.
}
\item{\code{limit_agents}}{
\code{(list , NULL)} Limit plotted agents to the agents in the list.
}
\item{\code{limit_context}}{
\code{(character vector , NULL)} Only plots data where context feature name(s) in vector equal to one.
}
\item{\code{no_par}}{
\code{(logical, FALSE)} If no_par is TRUE, Plot() does not set or adjust plotting parameters itself.
This makes it possible to set custom plotting parameters through R's par() function.
}
\item{\code{legend}}{
\code{(logical, TRUE)} Shows the legend when TRUE (default).
}
\item{\code{legend_title}}{
\code{(character , NULL)} Sets a custom legend title.
}
\item{\code{legend_labels}}{
\code{(character list , NULL)} Sets legend labels to custom values as specified in list.
}
\item{\code{legend_border}}{
\code{(logical , NULL)} When TRUE, the legend is borderless.
}
\item{\code{legend_position}}{
\code{(character , "topleft")} a single keyword from the list "bottomright", "bottom", "bottomleft",
"left", "topleft", "top", "topright", "right" and "center". This places the legend on the inside of
the plot frame at the given location.
}
\item{\code{xlim}}{
\code{(c(integer,integer), NULL)} Sets x-axis limits.
}
\item{\code{ylim}}{
\code{(c(integer,integer), NULL)} Sets y-axis limits.
}
\item{\code{log}}{
\code{(character , "")} A character string which contains "x" if the x axis is to be logarithmic,
"y" if the y axis is to be logarithmic and "xy" or "yx" if both axes are to be logarithmic.
}
\item{\code{use_colors}}{
\code{(logical, TRUE)} If use_colors is FALSE, plots will be in grayscale.
Otherwise, plots will make use of a color palette (default).
}
\item{\code{disp}}{
\code{(character, NULL)} When disp (for "dispersion measure") is set to either 'var','sd' or 'ci',
the variance, standard deviation, or 95% confidence interval will be added to the plot(s).
}
\item{\code{plot_only_disp}}{
\code{(logical, FALSE)} When TRUE and disp is either 'var','sd' or 'ci', plot only dispersion measure.
}
\item{\code{traces}}{
\code{(logical , FALSE)} Plot traces of independent simulations (default is FALSE).
}
\item{\code{traces_max}}{
\code{(integer , 100)} The number of trace lines.
}
\item{\code{traces_alpha}}{
\code{(numeric , 0.3)} Opacity of the trace lines. Default is 0.3 - that is, an opacity of 30%.
}
\item{\code{smooth}}{
\code{(logical , FALSE)} Smooth the plot (default is FALSE)
}
\item{\code{interval}}{
\code{(integer, NULL)} Plot only every t%%interval==0 data point.
}
\item{\code{cum_average}}{
\code{(logical , FALSE)} Calculates moving average from cum_reward or cum_regret with step
size \code{interval}.
}
\item{\code{color_step}}{
\code{(integer, 1)} When > 1, the plot cycles through \code{nr_agents/color_step} colors.
}
\item{\code{lty_step}}{
\code{(integer, 1)} When > 1, the plot cycles through \code{nr_agents/lty_step} line types.
}
\item{\code{lwd}}{
\code{(integer, 1)} Line width.
}
\item{\code{xlab}}{
\code{(character, NULL)} a title for the x axis
}
\item{\code{ylab}}{
\code{(character, NULL)} a title for the y axis
}
\item{\code{trunc_over_agents}}{
\code{(logical , TRUE)} Truncate the chart to the agent with the fewest time steps t.
}
\item{\code{trunc_per_agent}}{
\code{(logical , TRUE)} Truncate every agent's plot to the number of time steps that have been fully
simulated. That is, time steps for which the number of simulations equals the number defined in
\code{\link{Simulator}}'s \code{simulations} parameter.
}
}
}

\examples{
\dontrun{

bandit <- ContextualPrecachingBandit$new(weights = c(0.9, 0.1, 0.1))

agents <- list(Agent$new(RandomPolicy$new(), bandit),
               Agent$new(OraclePolicy$new(), bandit),
               Agent$new(ThompsonSamplingPolicy$new(1.0, 1.0), bandit),
               Agent$new(Exp3Policy$new(0.1), bandit),
               Agent$new(GittinsBrezziLaiPolicy$new(), bandit),
               Agent$new(UCB1Policy$new(), bandit))

history <- Simulator$new(agents, horizon = 100, simulations = 1000)$run()

par(mfrow = c(3, 2), mar = c(1, 4, 2, 1), cex=1.3)

plot(history, type = "cumulative", use_colors = FALSE, no_par = TRUE, legend_border = FALSE,
     limit_agents = c("GittinsBrezziLai", "UCB1","ThompsonSampling"))

plot(history, type = "cumulative", regret = FALSE, legend = FALSE,
     limit_agents = c("UCB1"), traces = TRUE, no_par = TRUE)

plot(history, type = "cumulative", regret = FALSE, rate = TRUE, disp = "sd",
     limit_agents = c("Exp3", "ThompsonSampling"),
     legend_position = "bottomright", no_par = TRUE)

plot(history, type = "cumulative", rate = TRUE, plot_only_disp = TRUE,
     disp = "var", smooth = TRUE, limit_agents = c("UCB1", "GittinsBrezziLai"),
    legend_position = "bottomleft", no_par = TRUE)

plot(history, type = "average", disp = "ci", regret = FALSE, interval = 10,
     smooth = TRUE, legend_position = "bottomright", no_par = TRUE, legend = FALSE)

plot(history, limit_agents = c("ThompsonSampling"), type = "arms",
     interval = 20, no_par = TRUE)

}


}
\seealso{
Core contextual classes: \code{\link{Bandit}}, \code{\link{Policy}}, \code{\link{Simulator}},
\code{\link{Agent}}, \code{\link{History}}, \code{\link{Plot}}

Bandit subclass examples: \code{\link{BasicBernoulliBandit}}, \code{\link{ContextualLogitBandit}},
\code{\link{OfflineReplayEvaluatorBandit}}

Policy subclass examples: \code{\link{EpsilonGreedyPolicy}}, \code{\link{ContextualLinTSPolicy}}
}
