% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/purge_cache.R
\name{purge_cache}
\alias{purge_cache}
\title{Purge older files from the local cache.}
\usage{
purge_cache(threshold = "1G", age = Inf, dir = content_dir())
}
\arguments{
\item{threshold}{Threshold size, accepts \verb{[fs::fs_bytes]} notation.}

\item{age}{Maximum age in days}

\item{dir}{the path we should use for permanent / on-disk storage
of the registry. An appropriate default will be selected (also
configurable using the environmental variable \code{CONTENTID_HOME}),
if not specified.}
}
\value{
invisibly returns dir path
}
\description{
Deletes oldest files until cache size is below the threshold size.
Additionally, users can specify a maximum age in days to delete all
files older than the threshold, which can speed up file purge in large
stores. Setting either age and threshold to 0 will purge everything from
cache.
}
\details{
Default behavior will keep \code{contentid}'s local store size below 1 GB.
Note that \code{contentid} functions do not automatically call purge_cache(),
this must be handled by user workflows.
}
