% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readability_indices.R
\name{calculate_readability_indices}
\alias{calculate_readability_indices}
\title{Calculate readability indices for text}
\usage{
calculate_readability_indices(text, detailed = FALSE)
}
\arguments{
\item{text}{Character vector containing the text to analyze}

\item{detailed}{Logical, if TRUE returns detailed statistics along with indices}
}
\value{
A tibble with the following columns:
\itemize{
\item flesch_kincaid_grade: US grade level required to understand the text
\item flesch_reading_ease: Score from 0-100 (higher = easier to read)
\item automated_readability_index: ARI grade level
\item gunning_fog_index: Grade level based on sentence length and complex words
}

If detailed = TRUE, also includes:
\itemize{
\item n_sentences: Number of sentences
\item n_words: Number of words
\item n_syllables: Total syllables
\item n_characters: Total characters
\item n_complex_words: Words with 3+ syllables
\item avg_sentence_length: Average words per sentence
\item avg_syllables_per_word: Average syllables per word
\item pct_complex_words: Percentage of complex words
}
}
\description{
Calculates multiple readability indices including Flesch-Kincaid Grade Level,
Flesch Reading Ease, Automated Readability Index (ARI), and Gunning Fog Index.
}
\details{
\strong{Formulas:}

\emph{Flesch-Kincaid Grade Level:}
\deqn{0.39 \times \frac{words}{sentences} + 11.8 \times \frac{syllables}{words} - 15.59}

\emph{Flesch Reading Ease:}
\deqn{206.835 - 1.015 \times \frac{words}{sentences} - 84.6 \times \frac{syllables}{words}}

\emph{Automated Readability Index (ARI):}
\deqn{4.71 \times \frac{characters}{words} + 0.5 \times \frac{words}{sentences} - 21.43}

\emph{Gunning Fog Index:}
\deqn{0.4 \times (\frac{words}{sentences} + 100 \times \frac{complex\_words}{words})}

where complex words are those with 3 or more syllables.
}
\examples{
\dontrun{
# Simple text
text <- "The cat sat on the mat. It was a sunny day."
readability <- calculate_readability_indices(text)

# With detailed statistics
text2 <- "Reading is fun. Books open new worlds. They teach us many things."
readability_detailed <- calculate_readability_indices(text2, detailed = TRUE)
}

}
