% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/has.R
\name{has}
\alias{has}
\alias{has.Container}
\alias{has.dict.table}
\title{Check for Element}
\usage{
has(x, ...)

\method{has}{Container}(x, elem, ...)

\method{has}{dict.table}(x, column, ...)
}
\arguments{
\item{x}{any \code{R} object.}

\item{...}{additional arguments to be passed to or from methods.}

\item{elem}{some element to be found.}

\item{column}{vector of values with the same length as the number of rows
of the \code{dict.table}.}
}
\value{
\code{TRUE} if element is in \code{x} and otherwise \code{FALSE}.

For \code{dict.table}, \code{TRUE} if column exists in \code{x} otherwise \code{FALSE}.
}
\description{
Check for Element
}
\examples{

co = container(1, 2, mean)
has(co, 1)                   # TRUE
has(co, mean)                # TRUE
has(co, 1:2)                 # FALSE

dit = dict.table(a = 1:3, b = as.list(4:6))
has(dit, 1:3)            # TRUE
has(dit, 4:6)            # FALSE
has(dit, as.list(4:6))   # TRUE
}
\seealso{
\code{\link[=has_name]{has_name()}}
}
