% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/set.R
\docType{class}
\name{Set}
\alias{Set}
\title{A Set class}
\format{An object of class \code{R6ClassGenerator} of length 24.}
\usage{
Set
}
\description{
The \code{Set} is considered and implemented as a specialized
\code{\link[container]{Container}}, that is, elements are always unique in the
\code{\link[container]{Container}} and it provides typical set operations such as
\code{union} and \code{intersect}.
}
\section{R6 constructor}{

\code{Set$new(x=list())}
}

\section{Inherited methods}{

Inherits all methods from \code{\link[container]{Container}}, but overrides
\code{add}:
\describe{
 \item{\code{add(elem)}}{If not already in set, add \code{elem}.}
}
}

\section{Set methods}{

\describe{
 \item{\code{union(s)}}{Return new \code{Set} as a result of the union of
 this and s.}
 \item{\code{intersect(s)}}{Return new \code{Set} as a result of the
     intersection of this and s.}
 \item{\code{diff(s)}}{Return new \code{Set} as a result of the set
     difference between this and s.}
 \item{\code{is.subset(s)}}{TRUE if this is a subset of s, else FALSE.}
 \item{\code{is.superset(s)}}{TRUE if this is a superset of s, else FALSE.}
}
}

\examples{
s1 <- Set$new()$add("A")
s1$values()                     # "A"
s1$add(2)$add("A")$values()     # "A" 2
s1$remove("A")$values()         # 2

#' \dontrun{
#' s1$remove(3)              # Error: 3 not in Set
#' }
}
\seealso{
\code{\link[container]{Container}}
}
\author{
Roman Pahl
}
\keyword{datasets}
