% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gen_text.R
\name{gen_text}
\alias{gen_text}
\alias{box_text}
\title{Generate label and bullet points}
\usage{
gen_text(x, label = NULL, bullet = FALSE)

box_text(x, label = NULL, bullet = FALSE)
}
\arguments{
\item{x}{A list or a vector to be used.}

\item{label}{A character string as a label at the beginning of the text label.
The count for each categories will be returned if no label is provided.}

\item{bullet}{If shows bullet points. If the value is `TRUE`, the bullet points
will be tabulated, default is `FALSE`.}
}
\value{
A character string of vector.
}
\description{
This function use the data to generate label and bullet points for the box.
}
\examples{
val <- data.frame(
  am = factor(ifelse(mtcars$am == 1, "Automatic", "Manual")),
  car = row.names(mtcars)
)

gen_text(val$car, label = "Cars in the data")
gen_text(val$car, label = "Cars in the data", bullet = FALSE)
gen_text(split(val$car, val$am), label = "Cars in the data")
gen_text(split(val$car, val$am), label = "Cars in the data", bullet = FALSE)
}
