% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/content.R
\name{get_log}
\alias{get_log}
\title{Get Job Log}
\usage{
get_log(job, max_log_lines = NULL)
}
\arguments{
\item{job}{A job, represented by an element from the list returned by \code{get_job_list()}.}

\item{max_log_lines}{Optional. An integer indicating the maximum number of
log lines to return. If \code{NULL} (default), Connect returns a maximum of 5000
lines.}
}
\value{
A data frame with the requested log. Each row represents an entry.
\itemize{
\item \code{source}: \code{stdout} or \code{stderr}
\item \code{timestamp}: The time of the entry.
\item \code{data}: The logged text.
}
}
\description{
Get the log output for a job. Requires Connect 2022.10.0 or newer.
}
\details{
Note: The output of \code{get_jobs()} cannot be used with \code{get_log()}.
Please use an object from the list returned by \code{get_job_list()}.
}
\examples{
\dontrun{
client <- connect()
item <- content_item(client, "951bf3ad-82d0-4bca-bba8-9b27e35c49fa")
jobs <- get_job_list(item)
log <- get_log(jobs[[1]])
}


}
\seealso{
Other job functions: 
\code{\link{get_job}()},
\code{\link{get_jobs}()},
\code{\link{terminate_jobs}()}

Other content functions: 
\code{\link{content_delete}()},
\code{\link{content_item}()},
\code{\link{content_title}()},
\code{\link{content_update}()},
\code{\link{create_random_name}()},
\code{\link{dashboard_url}()},
\code{\link{delete_thumbnail}()},
\code{\link{delete_vanity_url}()},
\code{\link{deploy_repo}()},
\code{\link{get_bundles}()},
\code{\link{get_environment}()},
\code{\link{get_image}()},
\code{\link{get_job}()},
\code{\link{get_jobs}()},
\code{\link{get_thumbnail}()},
\code{\link{get_vanity_url}()},
\code{\link{git}},
\code{\link{has_thumbnail}()},
\code{\link{permissions}},
\code{\link{set_image_path}()},
\code{\link{set_run_as}()},
\code{\link{set_thumbnail}()},
\code{\link{set_vanity_url}()},
\code{\link{swap_vanity_url}()},
\code{\link{swap_vanity_urls}()},
\code{\link{terminate_jobs}()},
\code{\link{verify_content_name}()}
}
\concept{content functions}
\concept{job functions}
