% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/report.R
\name{cong_committee_report}
\alias{cong_committee_report}
\title{Request Committee Report Information}
\usage{
cong_committee_report(
  congress = NULL,
  type = NULL,
  number = NULL,
  item = NULL,
  conference = FALSE,
  limit = 20,
  offset = 0,
  format = "json",
  clean = TRUE
)
}
\arguments{
\item{congress}{Congress number to search for. 81 or later are supported.}

\item{type}{Type of committee report. Can be \code{'hrpt'}, \code{'srpt'}, or \code{'erpt'}.}

\item{number}{Committee report assigned number. Numeric.}

\item{item}{Information to request. Can be  \code{'text'}.}

\item{conference}{Filter to conference reports. Default is \code{FALSE}.}

\item{limit}{number of records to return. Default is 20. Will be truncated to between 1 and 250.}

\item{offset}{number of records to skip. Default is 0. Must be non-negative.}

\item{format}{Output format for \code{clean = FALSE}. One of \code{xml} or \code{json}.}

\item{clean}{Default is TRUE. Should output be returned as a \code{tibble} if \code{clean = TRUE} or requested \code{format}.}
}
\value{
\code{tibble} or HTTP response if \code{clean = FALSE}
}
\description{
Request Committee Report Information
}
\examples{
\dontshow{if (congress::has_congress_key()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}

# Requires API Key

cong_committee_report()

cong_committee_report(conference = TRUE)

cong_committee_report(congress = 116)

cong_committee_report(congress = 116, type = 'hrpt')

cong_committee_report(congress = 116, type = 'hrpt', number = 617)
\dontshow{\}) # examplesIf}
}
