% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ci_measures_of_scale.R
\name{ci_IQR}
\alias{ci_IQR}
\title{CI for the IQR}
\usage{
ci_IQR(
  x,
  probs = c(0.025, 0.975),
  type = "bootstrap",
  boot_type = c("bca", "perc", "norm", "basic"),
  R = 9999L,
  seed = NULL,
  ...
)
}
\arguments{
\item{x}{A numeric vector.}

\item{probs}{Lower and upper probabilities, by default \code{c(0.025, 0.975)}.}

\item{type}{Type of CI. Currently not used as the only type is \code{"bootstrap"}.}

\item{boot_type}{Type of bootstrap CI c("bca", "perc", "norm", "basic").}

\item{R}{The number of bootstrap resamples. Only used for \code{type = "bootstrap"}.}

\item{seed}{An integer random seed. Only used for \code{type = "bootstrap"}.}

\item{...}{Further arguments passed to \code{\link[boot:boot]{boot::boot()}}.}
}
\value{
An object of class "cint", see \code{\link[=ci_mean]{ci_mean()}} for details.
}
\description{
This function calculates bootstrap CIs (by default "bca") for the population
interquartile range (IQR), i.e., the difference between first and third quartile.
}
\examples{
x <- rnorm(100)
ci_IQR(x, R = 999)  # Use larger R
}
