% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/noninferiority.R
\name{interpret_noninferiority}
\alias{interpret_noninferiority}
\title{Non-inferiority test interpretations of confidence intervals.}
\usage{
interpret_noninferiority(ci, actual_null = 0, ni_margin = 0.1,
  groups = c("Control intervention", "Test intervention"),
  beneficial_outcome = TRUE)
}
\arguments{
\item{ci}{A single row from a matrix of the type returned by \code{confint()},
containing the confidence interval for the parameter estimate. The two
columns provide the lower and upper confidence limits.}

\item{actual_null}{The value that precisely zero difference would have in
the parameter being examined. For an absolute measure this will typically
be 0. For a relative measure it will typically be 1. This is the starting
point that the \code{ni_margin} is applied to in order to establish the
point for comparison.}

\item{ni_margin}{Numerical value specifying the non-inferiority
margin to be used. Provided as a positive number; the value of
\code{beneficial_outcome} defines whether it is added to or subtracted
from the \code{actual_null} value to position the boundary. See Details.}

\item{groups}{A character vector of length 2 containing short descriptive names of the
groups being compared, such as the names of the interventions being
compared if the confidence interval is derived from an outcome effect
size measure in a randomised controlled trial. Give the name of the
intervention given to the comparison or control group first and the new
or tested intervention second.}

\item{beneficial_outcome}{Is the outcome to be treated as beneficial
(i.e., a higher value of the outcome is superior)? For harmful
outcomes (where lower numbers are better), set this to FALSE. If, for
example, the outcome is measuring something like prevalence of patients
recovering from a disease, that is likely to be beneficial; if it is
measuring the prevalence of patients falling ill with a disease it is
likely to be \strong{not} beneficial.}
}
\description{
Conduct non-inferiority tests on confidence intervals using a standard set
of interpretations. Takes a confidence interval around an effect size
measure, for example from the results from a randomised controlled trial
comparing  the outcome for an intervention group to a control group.
}
\details{
Non-inferiority tests are typically specified in analysis plans where a new
intervention is being compared to an existing one, especially if it has some
benefit other than the effect being measured. For example, the new
intervention might be cheaper than the old one, or have fewer side effects.
In these circumstances, the new intervention may not need to prove itself
more effective than the old one, but just to be not substantially worse -
i.e., non-inferior.

When conducting non-inferiority tests, a non-inferiority margin is defined.
This is effectively the leeway of small, practically insignificant
differences by which the new intervention is allowed to under-perform the
old one and still be considered non-inferior.

The non-inferiority margin is defined as being a small amount on the
inferior side of an actual null result. If using
\code{beneficial_outcome = TRUE} (the default), the non-inferiority margin
will extend below \code{actual_null}; if \code{beneficial_outcome = FALSE}
it extends above it.

You are able to supply descriptive names of the interventions being
compared, and these will be inserted into the resultant interpretation.
If the comparison / baseline intervention does not have a convenient name
(such as "Placebo"), some of these might be suitable:
\itemize{
 \item{"Business as usual"}
 \item{"Treatment as usual"}
 \item{"No intervention"}
}
(Whilst these may work well as short descriptions for outputting from
this function, in your reporting you will still normally want to provide
information about what exactly those in a comparison group got.)

This function is provided in the form of a convenience wrapper for
\code{\link{confinterpret}}, using
\code{\link{interpretations_superiority}} as its
\code{\link{interpretation_set}}.
}
