% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/curve_gen.R
\name{curve_gen}
\alias{curve_gen}
\title{Consonance Functions For Linear Models, Generalized Linear Models, and Robust Linear Models}
\usage{
curve_gen(model, var, method = "lm", steps = 1000, table = TRUE)
}
\arguments{
\item{model}{The statistical model of interest
(ANOVA, regression, logistic regression) is to be indicated here.}

\item{var}{The variable of interest from the model (coefficients, intercept)
for which the intervals are to be produced.}

\item{method}{Chooses the method to be used to calculate the
consonance intervals. There are currently threo methods:
"lm", "rlm", "glm" and "aov". The "lm" method uses the profile
likelihood method to compute intervals and can be used for models created by
the 'lm' function. It is typically what most people are
familiar with when computing intervals based on the calculated standard error.
The "rlm" method is designed for usage with the "rlm" function from the MASS
package.
The "glm" method allows this function to be used for specific scenarios like
logistic regression and the 'glm' function.}

\item{steps}{Indicates how many consonance intervals are to be calculated at
various levels. For example, setting this to 100 will produce 100 consonance
intervals from 0 to 100. Setting this to 10000 will produce more consonance
levels. By default, it is set to 1000. Increasing the number substantially
is not recommended as it will take longer to produce all the intervals and
store them into a dataframe.}

\item{table}{Indicates whether or not a table output with some relevant
statistics should be generated. The default is TRUE and generates a table
which is included in the list object.}
}
\value{
A list with 3 items where the dataframe of values is in the first
object, the values needed to calculate the density function in the second,
and the table for the values in the third if table = TRUE.
}
\description{
Computes thousands of consonance (confidence) intervals for
the chosen parameter in the selected model
(ANOVA, ANCOVA, regression, logistic regression) and places
the interval limits for each interval level into a data frame along
with the corresponding p-values and s-values.
}
\examples{

\donttest{
# Simulate random data
GroupA <- rnorm(50)
GroupB <- rnorm(50)
RandomData <- data.frame(GroupA, GroupB)
rob <- lm(GroupA ~ GroupB, data = RandomData)
bob <- curve_gen(rob, "GroupB")
}

}
