% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{hp_survey}
\alias{hp_survey}
\title{Results of Harry Potter Books Survey}
\format{A \link[tibble:tibble]{tibble} with answers from 182 respondents and the
following columns:
\itemize{
\item \strong{person} <int>: Identifier of a person.
\item \strong{book} <chr>: Identifier of a Harry Potter book. Its values are of the
form "HP_x" where "x" represents book's number in the series (from 1 to 7).
\item \strong{score} <chr>: Book's score. Can be one of "1 - Poor", "2 - Fair", "3 -
Good", "4 - Very Good", "5 - Excellent".
}

Rows are ordered by person and then by book identifier.}
\usage{
hp_survey
}
\description{
\code{hp_survey} contains results of the survey with a goal to collect data enough
to rate Harry Potter books.
}
\details{
Survey was done via
\href{https://www.google.com/intl/en/forms/about/}{Google Forms} service. To
participate in it, respondent is asked to log in into her/his Google account
(to ensure that one person takes part only once). It was popularized mostly
among R users via \href{https://www.r-bloggers.com/}{R-bloggers} and
\href{https://twitter.com/}{Twitter}.

At the beginning of the survey, there was the following text:

\emph{This is a survey with goal to collect data enough to rate Harry Potter books.
Data will be made public with complete anonymity of respondents. Please, take
part only if you have read all seven original J. K. Rowling Harry Potter
books and are willing to give an honest feedback about your impressions.}

Analyzed books were coded with the following names:
\itemize{
\item “HP and the Philosopher’s (Sorcerer’s) Stone (#1)”.
\item “HP and the Chamber of Secrets (#2)”.
\item “HP and the Prisoner of Azkaban (#3)”.
\item “HP and the Goblet of Fire (#4)”.
\item “HP and the Order of the Phoenix (#5)”.
\item “HP and the Half-Blood Prince (#6)”.
\item “HP and the Deathly Hallows (#7)”.
}

Survey had the following procedure:
\itemize{
\item At first, respondent is asked to choose the first element in the randomly
shuffled list of number from 1 to 127. This simulates the random generation
of books subset in the next question.
\item Next he/she is presented with a question "What is your impression of these
Harry Potter BOOKS?" (singular if there is one book) and the following
question grid:
\itemize{
\item Rows represent randomly shuffled subset of books corresponding to the
number chosen in the first step.
\item Columns contain the following scale of answers: “1 - Poor”, “2 - Fair”,
“3 - Good”, “4 - Very Good”, “5 - Excellent”. Respondent is asked and
allowed to choose only one answer per book (every book should be rated).
}
}
}
\keyword{datasets}
