% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/results-widecr.R
\name{widecr}
\alias{widecr}
\alias{is_widecr}
\alias{as_widecr}
\alias{as_tibble.widecr}
\title{Wide format of competition results}
\usage{
is_widecr(cr_data)

as_widecr(cr_data, repair = TRUE, ...)

\method{as_tibble}{widecr}(x, ...)
}
\arguments{
\item{cr_data}{Data of competition results (convertible to tabular).}

\item{repair}{Whether to repair input.}

\item{...}{Additional arguments to be passed to or from methods.}

\item{x}{Object to be converted to \link[tibble:tibble]{tibble}.}
}
\value{
\code{is_widecr()} returns \code{TRUE} if its argument is appropriate object
of class \code{widecr}: it should inherit classes \code{widecr}, \code{tbl_df} (in other
words, to be \link[tibble:tibble]{tibble}) and have complete pairs of
"player"-"score" columns where pair is detected by \strong{digits} after strings
"player" and "score" respectively.

\code{as_widecr()} returns an object of class \code{widecr}.

[as_tibble()[tibble::as_tibble()] applied to \code{widecr} object drops \code{widecr}
class.

[as_tibble()[tibble::as_tibble()]: R:as_tibble()[tibble::as_tibble()
}
\description{
Functions for dealing with competition results in wide format.
}
\details{
\code{as_widecr()} is S3 method for converting data to \code{widecr}. When
using \strong{default} method if \code{repair} is \code{TRUE} it also tries to fix
possible problems (see "Repairing"). If \code{repair} is \code{FALSE} it converts
\code{cr_data} to \link[tibble:tibble]{tibble} and adds \code{widecr} class to it.

When applying \code{as_widecr()} to proper (check via \code{\link[=is_longcr]{is_longcr()}} is made)
\strong{\code{longcr}} object, conversion is made:
\itemize{
\item All columns except "game", "player" and "score" are dropped.
\item Conversion from long to wide format is made. The number of "player"-"score"
pairs is taken as the maximum number of players in game. If not all games are
played between the same number of players then there will be \code{NA}'s in some
pairs. Column \code{game} is preserved in output and is used for arranging in
increasing order.
}

For appropriate \strong{\code{widecr}} objects \code{as_widecr} returns its input  and
throws error otherwise.
}
\section{Wide format of competition results}{

It is assumed that competition consists from multiple games (matches,
comparisons, etc.). One game can consist only from \strong{constant} number
of players. Inside a game all players are treated equally.
In every game every player has some score: the value of arbitrary nature
that fully characterizes player's performance in particular game (in most
cases it is some numeric value).

\code{widecr} inherits from \code{tibble}. Data should be organized in pairs of columns
"player"-"score". Identifier of a pair should go after respective keyword and
consist only from digits. For example: player1, score1, player2, score2.
Order doesn't matter. Extra columns are allowed.

To account for R standard string ordering, identifiers of pairs should be
formatted with leading zeros (when appropriate). For example: player01,
score01, ..., player10, score10.

Column \code{game} for game identifier is optional. If present it will be used in
conversion to \code{longcr} format via \code{\link[=as_longcr]{as_longcr()}}.
}

\section{Repairing}{

Option \code{repair = TRUE} (default) in \code{as_widecr()} means that its result is
going to be repaired with following actions:
\itemize{
\item Detect columns with names containing "player" or "score" (ignoring case).
All other columns are treated as "extra".
\item Extract first occurrence of "player" or "score" (ignoring case) from names
of detected columns. Everything after extracted word is treated as identifier
of "player"-"score" pair.
\item Convert these identifiers to numeric form with
\code{as.integer(as.factor(...))}.
\item Convert identifiers once again to character form with possible leading
zeros (to account for R standard string ordering).
\item Spread pairs to appropriate columns with possible column adding (which
were missed in original pairs based on information of pair identifier) with
\code{NA_integer_}.
\item \strong{Note} that if there is column \code{game} (exactly matched) it is placed as
first column.
\strong{Note} that the order (and numeration) of pairs can change.
}
}

\examples{
cr_data <- data.frame(
  playerA = 1:10,
  playerB = 2:11,
  scoreC = 11:20,
  scoreB = 12:21,
  otherColumn =  101:110
)
cr_data_wide <- as_widecr(cr_data, repair = TRUE)

is_widecr(cr_data_wide)

as_tibble(cr_data_wide)

}
\seealso{
\link[=longcr]{Long format}
}
