% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/csub.R
\name{csub}
\alias{csub}
\title{a function to change column names}
\usage{
csub(x, pattern, replacement, dim = c("c", "r"), gl = TRUE)
}
\arguments{
\item{x}{A dataframe, list or matrix with column names}

\item{pattern}{A string}

\item{replacement}{A string}

\item{dim}{A character either "c" for selection of columns or "r" for selection of rows, if x is a list this
parameter has no meaning}

\item{gl}{A boolean, if TRUE (the default) all occurences in the input strings (row or column names) are replaced,
if FALSE only the first occurence in every string is replaced.}
}
\value{
A dataframe, list or matrix where the columns or rows are renamed based on the 'Regex' substitution
defined in the pattern and the replacement. By default column are renamed, unless the dim parameter specifies
"r" for rows.
The default is to use gsub (replacing all occurences of pattern in each column name), to replace only the first
occurence set gl to FALSE.

For lists the function acts on the highest level of the list and this is irrespective of the gl parameter.
}
\description{
a function to change column names
}
\examples{
head(csub(iris, "\\\\.", "-")) # will change all dots in column names in "-"
head(csub(iris, "[pP]etal", "Beetle"))

# a more complex example showing the power of 'regex'

head(csub(data.frame(WorldPhones),"^([NM](?:\\\\w{2})?\\\\.)Amer", "\\\\1America"))


# this example will also work on other types (the call data.frame is not necessary)

}
\seealso{
\link[base]{regex}\{base\}
}

