% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/colour_values.R
\name{colour_values}
\alias{colour_values}
\title{Colour Values}
\usage{
colour_values(x, palette = "viridis", na_colour = "#808080FF",
  alpha = 255, include_alpha = TRUE)
}
\arguments{
\item{x}{vector of values to map to a colour}

\item{palette}{colour palette. See details and examples}

\item{na_colour}{hex string colour to use for NA values in the form \code{#RRGGBBAA}.}

\item{alpha}{optional. Single value in [0,255] applied to all colours, or
a vector of numeric values the same length as \code{x}. The numeric vector
will be scaled into the range [0,255].
If a matrix palette is supplied this argument is ignored.}

\item{include_alpha}{logical indicating if the returned hex or matrix should include
the alpha values. Defaults to \code{TRUE}}
}
\value{
string vector of hex colours
}
\description{
maps colours to values
}
\details{
The palette can either be
\itemize{
  \item{String - }{"viridis", "inferno", "plasma", "magma", "cividis"}
  \item{Matrix - }{At least 5 rows, and 3 (or 4) columns representing the red, green and blue (and alpha) values}
}
}
\examples{

## in-built palettes
colour_values(x = 1:5) ## default is "viridis"
colour_values(x = 1:5, palette = "inferno")
colour_values(x = 1:5, palette = "plasma")
colour_values(x = 1:5, palette = "magma")
colour_values(x = 1:5, palette = "cividis")

## matrix palette
n <- 100
m <- grDevices::colorRamp(c("red", "green"))( (1:n)/n )
df <- data.frame(a = 10, x = 1:n)
df$col <- colour_values(df$x, palette = m)
barplot(height = df$a, col = df$col, border = NA, space = 0)

## with an alpha column on the palette
n <- 100
m <- grDevices::colorRamp(c("red", "green"))( (1:n)/n )
m <- cbind(m, seq(0, 255, length.out = 100))
df <- data.frame(a = 10, x = 1:n)
df$col <- colour_values(df$x, palette = m)
barplot(height = df$a, col = df$col, border = NA, space = 0)

## single alpha value for all colours
df <- data.frame(a = 10, x = 1:255)
df$col <- colour_values(df$x, alpha = 50)
barplot(height = df$a, col = df$col, border = NA, space = 0)

## vector of alpha values
df <- data.frame(a = 10, x = 1:300, y = rep(c(1:50, 50:1), 3) )
df$col <- colour_values(df$x, alpha = df$y)
barplot(height = df$a, col = df$col, border = NA, space = 0)

}
