% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/preference_order.R
\name{f_gam_auc_balanced}
\alias{f_gam_auc_balanced}
\title{AUC of Logistic GAM Model}
\usage{
f_gam_auc_balanced(x, y, df)
}
\arguments{
\item{x}{(required, character string) name of the predictor variable.}

\item{y}{(required, character string) name of the binary response variable.}

\item{df}{(required, data frame) data frame with the columns 'x' and 'y'.}
}
\value{
Area Under the Curve
}
\description{
Fits a binomial logistic Generalized Additive Model (GAM) \code{y ~ s(x, k = 3)} between a binary response and a numeric predictor and returns the Area Under the Curve of the observations versus the predictions.
}
\examples{

data(vi)

#subset to limit example run time
vi <- vi[1:1000, ]

#this example requires "mgcv" installed
if(requireNamespace(package = "mgcv", quietly = TRUE)){

  f_gam_auc_balanced(
    x = "growing_season_length", #predictor
    y = "vi_binary",               #response
    df = vi
  )

}

}
