% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit_distributions.R
\name{combine_lognorm_trunc}
\alias{combine_lognorm_trunc}
\title{Weight a set of lognormal parameters into a single distribution}
\usage{
combine_lognorm_trunc(dat)
}
\arguments{
\item{dat}{Dataframe of meanlog, sdlog, min, max, and sdlog.}
}
\value{
A dataframe.
}
\description{
Weight a set of lognormal parameters into a single distribution
}
\examples{
dat <- data.frame(meanlog = c(1, 1.5),
                  sdlog = c(1, 2),
                  min = 0,
                  max = Inf,
                  weight = c(2, 1))
combine_lognorm_trunc(dat)
}
\seealso{
Other distribution fitting functions: 
\code{\link{combine_lognorm}()},
\code{\link{combine_norm}()},
\code{\link{fit_capabilities_geomean}()},
\code{\link{fit_capabilities}()},
\code{\link{fit_lognorm_trunc}()},
\code{\link{fit_lognorm}()},
\code{\link{fit_norm_trunc}()},
\code{\link{fit_pois}()},
\code{\link{fit_scenarios_geomean}()},
\code{\link{fit_scenarios}()},
\code{\link{fit_threat_communities}()},
\code{\link{generate_cost_function}()},
\code{\link{lognormal_to_normal}()},
\code{\link{normal_to_lognormal}()}
}
\concept{distribution fitting functions}
