% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cogmapr.R
\name{ggCMap}
\alias{ggCMap}
\title{Plot a social cognitive map using ggplot2}
\usage{
ggCMap(data, size.concepts = 4, size.labels = 4, size.edges = 4,
  size.arrows = 4, alpha.arrows = 0.3)
}
\arguments{
\item{data}{A list, the output of the 'data.ggCMap' function, containing all useful vertex and edge information for the cognitive maps.}

\item{size.concepts}{Size of the dot linked to vertices}

\item{size.labels}{Size of the labels of vertices}

\item{size.edges}{Size of the lables of the weight of edges}

\item{size.arrows}{Size of arrows (head)}

\item{alpha.arrows}{The transparency of arrows.}
}
\value{
A ggplot of a social cognitive map
}
\description{
Plotting the a social cognitive map using ggplot2
}
\details{
Plotting the a social cognitive map using ggplot2
}
\examples{
project_name <- "a_new_project"
main_path <- paste0(system.file("testdata", package = "cogmapr"), '/')
my.project <- ProjectCMap(main_path, project_name)

df.scm <- data.ggCMap(my.project, edge.filter = "4")
ggCMap(df.scm)
}
