% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/draw_potential.r
\name{draw_potential}
\alias{draw_potential}
\title{Visualize Potential-Based Center of Gravity (COG) and Potential Field}
\usage{
draw_potential(lst, show_cog = TRUE, plot_image = TRUE)
}
\arguments{
\item{lst}{A list returned by \code{\link{cog_potential}}, containing
a data frame of normalized potentials and computed statistics.}

\item{show_cog}{Logical. If \code{TRUE} (default), draws horizontal and vertical
red lines through the COG.}

\item{plot_image}{Logical. If \code{TRUE} (default), plots the generated image. If \code{FALSE},
returns the image object without displaying it.}
}
\value{
An object of class \code{cimg} representing the potential field image,
optionally overlaid with COG crosshair lines.
}
\description{
Visualizes the normalized potential field and center of gravity (COG) computed by \code{\link{cog_potential}}.
Each pixel's potential is shown as grayscale intensity, where darker pixels indicate higher potential.
Optionally overlays crosshair lines at the computed COG to indicate its position.
}
\examples{
\dontshow{if ((identical(Sys.getenv("IN_PKGDOWN"), "true") || interactive())) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
\donttest{
  data(img_A) # load example image from the package
  result <- cog_potential(img_A)
  draw_potential(result, show_cog = TRUE)
}
\dontshow{\}) # examplesIf}
}
\seealso{
\code{\link{cog_potential}}
}
