% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/jamil-sim.R
\name{simJamil}
\alias{simJamil}
\title{Simulate species abundance data following Jamil & ter Braak
(2013)}
\usage{
simJamil(n, m, x, gl = 4, randx = TRUE, tol = 0.5, tau = gl/2,
  randm = TRUE, expectation = FALSE)
}
\arguments{
\item{n}{numeric; the number of samples/sites.}

\item{m}{numeric, the number of species/variables.}

\item{x}{numeric; values for the environmental gradient. Can be
missing, in which case suitable values are generated. See Details.}

\item{gl}{numeric; gradient length in arbitrary units. The default
is 4 units with gradient values ranging from -2 to 2.}

\item{randx}{logical; should locations along the gradient (\code{x})
be located randomly or equally-spaced?}

\item{tol}{numeric; the species tolerances. Can be a vector of
length \code{m}, hence allowing for varying tolerances along the
gradient \code{x}.}

\item{tau}{numeric; constant that ensures some of the optima are
located beyond the observed gradient end points.}

\item{randm}{logical; should species optima along the gradient be
located randomly or equally-spaced?}

\item{expectation}{logical; if \code{TRUE} the binomial probabilities
\eqn{p_{ij}}{p[ij]} from the response curve are returned directly. If
\code{FALSE}, the default, random draws from a Bernoulli distribution
with probability \eqn{p_{ij}}{p[ij]} are made.}
}
\value{
a matrix of \code{n} rows and \code{m} columns containing the
simulated species abundance data.
}
\description{
Simulate species probability of occurrence data according
to the method used by Tahira Jamil and Cajo ter Braak in their recent
paper \emph{Generalized linear mixed models can detect unimodal
species-environment relationships}.
}
\examples{
set.seed(42)
N <- 100   # Number of locations on gradient (samples)
glen <- 4  # Gradient length
grad <- sort(runif(N, -glen/2, glen/2)) # sample locations
M <- 10    # Number of species
sim <- simJamil(n = N, m = M, x = grad, gl = glen, randx = FALSE,
                randm = FALSE, expectation = TRUE)
## visualise the response curves
matplot(grad, sim, type = "l", lty = "solid")

## simulate binomial responses from those response curves
sim <- simJamil(n = N, m = M, x = grad, gl = glen, randx = FALSE,
                randm = FALSE)
}
\author{
Gavin L. Simpson
}
\references{
Jamil and ter Braak (2013) Generalized linear mixed models can detect unimodal species-environment relationships. \emph{PeerJ} \strong{1:e95}; DOI \href{http://doi.org/10.7717/peerj.95}{10.7717/peerj.95}.
}
\keyword{datagen}

