% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc.R
\name{md_pattern}
\alias{md_pattern}
\title{Missing data patterns}
\usage{
md_pattern(data, only_vars_with_missings = TRUE, min_freq = 0.01)
}
\arguments{
\item{data}{the dataset}

\item{only_vars_with_missings}{defaults to TRUE, omitting variables that have no missings}

\item{min_freq}{minimum number of rows to have this missingness pattern}
}
\description{
Generate missingness patterns using \code{\link[mice:md.pattern]{mice::md.pattern()}},
with options to reduce the complexity of the output.
}
\examples{
data("nhanes", package = "mice")
md_pattern(nhanes)
md_pattern(nhanes, only_vars_with_missings = FALSE, min_freq = 0.2)
}
