% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coordinates.R
\name{pb_basis}
\alias{pb_basis}
\title{Isometric log-ratio basis based on Principal Balances.}
\usage{
pb_basis(X, method, rep = 0, ordering = TRUE, ...)
}
\arguments{
\item{X}{compositional dataset}

\item{method}{method to be used with Principal Balances. Methods available are: 'exact', 'lsearch' or
method to be passed to hclust function (for example `ward.D` or `ward.D2` to use Ward method).}

\item{rep}{Number of restartings to be used with the local search algorithm. If zero is supplied
(default), one local search is performed using an starting point close to the principal component
solution.}

\item{ordering}{should the principal balances found be returned ordered? (first column, first
principal balance and so on)}

\item{...}{parameters passed to hclust function}
}
\value{
matrix
}
\description{
Different approximations to approximate the principal balances of a compositional dataset.
}
\examples{
set.seed(1)
X = matrix(exp(rnorm(5*100)), nrow=100, ncol=5)
# Optimal variance obtained with Principal components
(v1 <- apply(coordinates(X, 'pc'), 2, var))
# Optimal variance obtained with Principal balances
(v2 <- apply(coordinates(X,pb_basis(X, method='exact')), 2, var))
# Solution obtained using a hill climbing algorithm from pc approximation
apply(coordinates(X,pb_basis(X, method='lsearch')), 2, var)
# Solution obtained using a hill climbing algorithm using 10 restartings
apply(coordinates(X,pb_basis(X, method='lsearch', rep=10)), 2, var)
# Solution obtained using Ward method
(v3 <- apply(coordinates(X,pb_basis(X, method='ward.D2')), 2, var))
# Solution obtained using Old Ward function (in R versions <= 3.0.3)
apply(coordinates(X,pb_basis(X, method='ward.D')), 2, var)
# Plotting the variances
barplot(rbind(v1,v2,v3), beside = TRUE, legend = c('PC','PB','Ward'), args.legend = list(cex = 0.8))

}
\references{
Pawlowsky-Glahn, V., Egozcue, J.J., Tolosana-Delgado R. (2011).
\emph{Principal balances}.
in proceeding of the 4th International Workshop on Compositional Data Analysis (CODAWORK'11) (available online at \url{http://www-ma3.upc.edu/users/ortego/codawork11-Proceedings/Admin/Files/FilePaper/p55.pdf})
}
