% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.coco.R
\name{predict.coco}
\alias{predict.coco}
\title{K-Step Ahead Forecast Bootstrapping}
\usage{
\method{predict}{coco}(
  object,
  k = 1,
  number_simulations = 1000,
  alpha = 0.05,
  simulate_one_step_ahead = FALSE,
  max = NULL,
  epsilon = 1e-08,
  xcast = NULL,
  decimals = 4,
  julia = FALSE,
  ...
)
}
\arguments{
\item{object}{An object that has been fitted previously, of class coco.}

\item{k}{The number of steps ahead for which the forecast should be computed. Defaults to 3.}

\item{number_simulations}{The number of simulation runs to compute. Defaults to 500.}

\item{alpha}{Level of confidence that is used to construct the prediction intervals.}

\item{simulate_one_step_ahead}{If FALSE, the one-step ahead prediciton is obtained using the analytical distribution. If TRUE, bootstrapping is used.}

\item{max}{The maximum number of the forecast support for the plot. If NULL all values for which the cumulative distribution function is below 1- epsilon are used for the plot.}

\item{epsilon}{If max is NULL, epsilon determines the range of the support that is used by subsequent automatic plotting using R's plot() function.}

\item{xcast}{An optional matrix of covariate values for the forecasting. If `NULL`, the function assumes no covariates.}

\item{decimals}{Number of decimal places for the forecast probabilities}

\item{julia}{if TRUE, the estimate is predicted with Julia.}

\item{...}{Optional arguments.}
}
\value{
A list of frequency tables. Each table represents a k-step ahead forecast frequency distribution based on the simulation runs.
}
\description{
Computes the k-step ahead forecast using the models in the coconots package.
}
\details{
Returns forecasts for each mass point of the k-step ahead
distribution for the fitted model. The exact predictive distributions for
one-step ahead predicitons for
the models included here are provided in Jung and Tremayne (2011), maximum
likelihood estimates replace the true model parameters. Out-of-sample values
for covariates can be provided, if necessary.
}
