% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bal.tab.formula.R
\name{bal.tab.formula}
\alias{bal.tab.formula}
\alias{bal.tab.data.frame}
\alias{bal.tab.matrix}
\title{Balance Statistics for Data Sets}
\usage{
\method{bal.tab}{formula}(
  x,
  data = NULL,
  stats,
  int = FALSE,
  poly = 1,
  distance = NULL,
  addl = NULL,
  continuous,
  binary,
  s.d.denom,
  thresholds = NULL,
  weights = NULL,
  cluster = NULL,
  imp = NULL,
  pairwise = TRUE,
  s.weights = NULL,
  abs = FALSE,
  subset = NULL,
  quick = TRUE,
  subclass = NULL,
  match.strata = NULL,
  method,
  estimand = NULL,
  focal = NULL,
  ...
)

\method{bal.tab}{data.frame}(
  x,
  treat,
  stats,
  int = FALSE,
  poly = 1,
  distance = NULL,
  addl = NULL,
  data = NULL,
  continuous,
  binary,
  s.d.denom,
  thresholds = NULL,
  weights = NULL,
  cluster = NULL,
  imp = NULL,
  pairwise = TRUE,
  s.weights = NULL,
  abs = FALSE,
  subset = NULL,
  quick = TRUE,
  subclass = NULL,
  match.strata = NULL,
  method,
  estimand = NULL,
  focal = NULL,
  ...
)

\method{bal.tab}{matrix}(
  x,
  treat,
  stats,
  int = FALSE,
  poly = 1,
  distance = NULL,
  addl = NULL,
  data = NULL,
  continuous,
  binary,
  s.d.denom,
  thresholds = NULL,
  weights = NULL,
  cluster = NULL,
  imp = NULL,
  pairwise = TRUE,
  s.weights = NULL,
  abs = FALSE,
  subset = NULL,
  quick = TRUE,
  subclass = NULL,
  match.strata = NULL,
  method,
  estimand = NULL,
  focal = NULL,
  ...
)
}
\arguments{
\item{x}{either a \code{data.frame} containing covariate values for each unit or a \code{formula} with the treatment variable as the response and the covariates for which balance is to be assessed as the terms. If a formula is supplied, all terms must be present as variable names in \code{data} or the global environment.}

\item{data}{an optional data frame containing variables named in other arguments. For some input object types, this is required.}

\item{stats}{\code{character}; which statistic(s) should be reported. See \code{\link[=balance-statistics]{stats}} for allowable options. For binary and multi-category treatments, \code{"mean.diffs"} (i.e., mean differences) is the default. For continuous treatments, \code{"correlations"} (i.e., treatment-covariate Pearson correlations) is the default. Multiple options are allowed.}

\item{int}{\code{logical} or \code{numeric}; whether or not to include 2-way interactions of covariates included in \code{covs} and in \code{addl}. If \code{numeric}, will be passed to \code{poly} as well.}

\item{poly}{\code{numeric}; the highest polynomial of each continuous covariate to display. For example, if 2, squares of each continuous covariate will be displayed (in addition to the covariate itself); if 3, squares and cubes of each continuous covariate will be displayed, etc. If 1, the default, only the base covariate will be displayed. If \code{int} is numeric, \code{poly} will take on the value of \code{int}.}

\item{distance}{an optional formula or data frame containing distance values (e.g., propensity scores) or a character vector containing their names. If a formula or variable names are specified, \code{bal.tab()} will look in the argument to \code{data}, if specified. For longitudinal treatments, can be a list of allowable arguments, one for each time point.}

\item{addl}{an optional formula or data frame containing additional covariates for which to present balance or a character vector containing their names. If a formula or variable names are specified, \code{bal.tab()} will look in the arguments to the input object, \code{covs}, and \code{data}, if specified. For longitudinal treatments, can be a list of allowable arguments, one for each time point.}

\item{continuous}{whether mean differences for continuous variables should be standardized (\code{"std"}) or raw (\code{"raw"}). Default \code{"std"}. Abbreviations allowed. This option can be set globally using \code{\link[=set.cobalt.options]{set.cobalt.options()}}.}

\item{binary}{whether mean differences for binary variables (i.e., difference in proportion) should be standardized (\code{"std"}) or raw (\code{"raw"}). Default \code{"raw"}. Abbreviations allowed. This option can be set globally using \code{\link[=set.cobalt.options]{set.cobalt.options()}}.}

\item{s.d.denom}{\code{character}; how the denominator for standardized mean differences should be calculated, if requested. See \code{\link[=col_w_smd]{col_w_smd()}} for allowable options. Abbreviations allowed. If weights are supplied, each set of weights should have a corresponding entry to \code{s.d.denom}; a single entry will be recycled to all sets of weights. If left blank and one of \code{weights}, \code{subclass}, or \code{match.strata} are supplied, \code{bal.tab()} will figure out which one is best based on \code{estimand}, if given (for ATT, \code{"treated"}; for ATC, \code{"control"}; otherwise "pooled") and other clues if not.}

\item{thresholds}{a named vector of balance thresholds, where the name corresponds to the statistic (i.e., in \code{stats}) that the threshold applies to. For example, to request thresholds on mean differences and variance ratios, one can set \code{thresholds = c(m = .05, v = 2)}. Requesting a threshold automatically requests the display of that statistic. When specified, extra columns are inserted into the Balance table describing whether the requested balance statistics exceeded the threshold or not. Summary tables tallying the number of variables that exceeded and were within the threshold and displaying the variables with the greatest imbalance on that balance measure are added to the output.}

\item{weights}{a vector, list, or \code{data.frame} containing weights for each unit, or a string containing the names of the weights variables in \code{data}, or an object with a \code{\link[=get.w]{get.w()}} method or a list thereof. The weights can be, e.g., inverse probability weights or matching weights resulting from a matching algorithm.}

\item{cluster}{either a vector containing cluster membership for each unit or a string containing the name of the cluster membership variable in \code{data} or the input object. See \code{\link{class-bal.tab.cluster}} for details.}

\item{imp}{either a vector containing imputation indices for each unit or a string containing the name of the imputation index variable in \code{data} or the input object. See \code{\link{class-bal.tab.imp}} for details. Not necessary if \code{data} is a \code{mids} object.}

\item{pairwise}{whether balance should be computed for pairs of treatments or for each treatment against all groups combined. See \code{\link[=class-bal.tab.multi]{bal.tab.multi()}} for details. This can also be used with a binary treatment to assess balance with respect to the full sample.}

\item{s.weights}{Optional; either a vector containing sampling weights for each unit or a string containing the name of the sampling weight variable in \code{data}. These function like regular weights except that both the adjusted and unadjusted samples will be weighted according to these weights if weights are used.}

\item{abs}{\code{logical}; whether displayed balance statistics should be in absolute value or not.}

\item{subset}{a \code{logical} or \code{numeric} vector denoting whether each observation should be included or which observations should be included. If \code{logical}, it should have length equal to the number of units. \code{NA}s will be treated as \code{FALSE}. This can be used as an alternative to \code{cluster} to examine balance on subsets of the data.}

\item{quick}{\code{logical}; if \code{TRUE}, will not compute any values that will not be displayed. Set to \code{FALSE} if computed values not displayed will be used later.}

\item{subclass}{optional; either a vector containing subclass membership for each unit or a string containing the name of the subclass variable in \code{data}.}

\item{match.strata}{optional; either a vector containing matching stratum membership for each unit or a string containing the name of the matching stratum variable in \code{data}. See Details.}

\item{method}{\code{character}; the method of adjustment, if any. If \code{weights} are specified, the user can specify either "matching" or "weighting"; "weighting" is the default. If multiple sets of weights are used, each must have a corresponding value for \code{method}, but if they are all of the same type, only one value is required. If \code{subclass} is specified, "subclassification" is the default. Abbreviations allowed. The only distinction between "matching" and "weighting" is how sample sizes are displayed.}

\item{estimand}{\code{character}; whether the desired estimand is the "ATT", "ATC", or "ATE" for each set of weights. This argument can be used in place of \code{s.d.denom} to specify how standardized differences are calculated.}

\item{focal}{the name of the focal treatment when multi-category treatments are used. See \code{\link[=class-bal.tab.multi]{bal.tab.multi()}} for details.}

\item{...}{for some input types, other arguments that are required or allowed. Otherwise, further arguments to control display of output. See \link[=display-options]{display options} for details.}

\item{treat}{either a vector containing treatment status values for each unit or a string containing the name of the treatment variable in \code{data}. Required for the \code{data.frame} method.}
}
\value{
For point treatments, if clusters and imputations are not specified, an object of class \code{"bal.tab"} containing balance summaries for the specified treatment and covariates. See \code{\link[=bal.tab]{bal.tab()}} for details.

If imputations are specified, an object of class \code{"bal.tab.imp"} containing balance summaries for each imputation and a summary of balance across imputations. See \code{\link{class-bal.tab.imp}} for details.

If multi-category treatments are used, an object of class \code{"bal.tab.multi"} containing balance summaries for each pairwise treatment comparison. See \code{\link[=class-bal.tab.multi]{bal.tab.multi()}} for details.

If clusters are specified, an object of class \code{"bal.tab.cluster"} containing balance summaries within each cluster and a summary of balance across clusters. See \code{\link{class-bal.tab.cluster}} for details.
}
\description{
Generates balance statistics for unadjusted, matched, weighted, or stratified data using either a \code{data.frame} or formula interface.
}
\details{
\code{bal.tab.data.frame()} generates a list of balance summaries for the covariates and treatment status values given. \code{bal.tab.formula()} does the same but uses a formula interface instead.  When the formula interface is used, the formula and data are reshaped into a treatment vector and \code{data.frame} of covariates and then simply passed through the \code{data.frame} method.

If \code{weights}, \code{subclass} and \code{match.strata} are all \code{NULL}, balance information will be presented only for the unadjusted sample.

The argument to \code{match.strata} corresponds to a factor vector containing the name or index of each pair/stratum for units conditioned through matching, for example, using the \pkg{optmatch} package. If more than one of \code{weights}, \code{subclass}, or \code{match.strata} are specified, \code{bal.tab()} will attempt to figure out which one to apply. Currently only one of these can be applied ta a time. \code{bal.tab()} behaves differently depending on whether subclasses are used in conditioning or not. If they are used, \code{bal.tab()} creates balance statistics for each subclass and for the sample in aggregate. See \code{\link{class-bal.tab.subclass}} for more information.

Multiple sets of weights can be supplied simultaneously by entering a \code{data.frame} or a character vector containing the names of weight variables found in \code{data} or a list of weights vectors or names. The arguments to \code{method}, \code{s.d.denom}, and \code{estimand}, if any, must be either the same length as the number of sets of weights or of length one, where the sole entry is applied to all sets. When standardized differences are computed for the unadjusted group, they are done using the first entry to \code{s.d.denom} or \code{estimand}. When only one set of weights is supplied, the output for the adjusted group will simply be called \code{"Adj"}, but otherwise will be named after each corresponding set of weights. Specifying multiple sets of weights will also add components to other outputs of \code{bal.tab()}.
}
\examples{
data("lalonde", package = "cobalt")
lalonde$p.score <- glm(treat ~ age + educ + race, data = lalonde, 
                       family = "binomial")$fitted.values
covariates <- subset(lalonde, select = c(age, educ, race))

## Propensity score weighting using IPTW
lalonde$iptw.weights <- ifelse(lalonde$treat==1, 
                               1/lalonde$p.score, 
                               1/(1-lalonde$p.score))

# data frame interface:
bal.tab(covariates, treat = "treat", data = lalonde, 
        weights = "iptw.weights", s.d.denom = "pooled")

# Formula interface:
bal.tab(treat ~ age + educ + race, data = lalonde, 
        weights = "iptw.weights", s.d.denom = "pooled")

## Propensity score subclassification
lalonde$subclass <- findInterval(lalonde$p.score, 
                                 quantile(lalonde$p.score, 
                                          (0:6)/6), all.inside = TRUE)

# data frame interface:
bal.tab(covariates, treat = "treat", data = lalonde, 
        subclass = "subclass", disp.subclass = TRUE, 
        s.d.denom = "pooled")

# Formula interface:
bal.tab(treat ~ age + educ + race, data = lalonde, 
        subclass = "subclass", disp.subclass = TRUE, 
        s.d.denom = "pooled")
}
\seealso{
\itemize{
\item \code{\link[=bal.tab]{bal.tab()}} for details of calculations.
\item \code{\link{class-bal.tab.cluster}} for more information on clustered data.
\item \code{\link{class-bal.tab.imp}} for more information on multiply imputed data.
\item \code{\link[=class-bal.tab.multi]{bal.tab.multi()}} for more information on multi-category treatments.
}
}
