% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/acsaf_box_mergetime.R
\name{acsaf_box_mergetime}
\alias{acsaf_box_mergetime}
\title{Function to combine ACSAF NetCDF files and simultaneously cut a region.}
\usage{
acsaf_box_mergetime(
  path,
  pattern,
  outfile,
  lon1 = -180,
  lon2 = 180,
  lat1 = -90,
  lat2 = 90,
  nc34 = 3
)
}
\arguments{
\item{path}{The directory of input NetCDF files without / at the end
(character).}

\item{pattern}{A part of the filename, which is the same for all desired input
files (character). The pattern has to be a character string containing a
regular expression.}

\item{outfile}{Filename of output NetCDF file. This may include the directory
(character).}

\item{lon1}{Longitude of lower left corner (numeric).}

\item{lon2}{Longitude of upper right left corner (numeric).}

\item{lat1}{Latitude of lower left corner (numeric).}

\item{lat2}{Latitude of upper right corner (numeric).  Longitude of upper
right corner (numeric).}

\item{nc34}{NetCDF version of output file. If \code{nc34 = 3} the output file will be
in NetCDFv3 format (numeric). Default output is NetCDFv4.}
}
\value{
A NetCDF file including the merged time series of the selected region
is written.
}
\description{
This function selects a region (and optionally a level) from a bunch of AC SAF
NetCDF files that match the same pattern of the filename, and writes the
output to a new file.
}
\seealso{
Other data manipulation functions: 
\code{\link{add_grid_info}()},
\code{\link{box_mergetime}()},
\code{\link{cmsaf.transform.coordinate.system}()},
\code{\link{levbox_mergetime}()},
\code{\link{map_regular}()},
\code{\link{remap}()}
}
\concept{data manipulation functions}
