data_dir <- file.path("..", "testdata")
tempfile_nc <- function() {
  tempfile_helper("timcovar_")
}

########## output ncdf version 3 ##########
file_in_1 <- file.path(data_dir, "ex_tim_cor_covar_1.nc")
file_in_2 <- file.path(data_dir, "ex_tim_cor_covar_2.nc")
file_out <- tempfile_nc()
timcovar("SIS", file_in_1, "SIS", file_in_2, file_out)
file <- nc_open(file_out)

test_that("data is correct", {
  actual <- ncvar_get(file)
  
  expected_data <- c(-0.33333334,95.0,208.0,-126.166664,7.3333335,255.33333,140.83333,154.66667,-546.6667,-79.333336,-315.33334,398.0,-182.0,268.66666,-96.0,-7.1666665,-218.66667,462.66666,-68.333336,26.333334,-99.166664,
                     144.0,-264.33334,-276.0,-128.0,-417.66666,306.66666,-570.6667,-456.0,-240.5,-21.666666,88.0,-51.166668,28.833334,-22.333334,285.33334,-209.16667,-132.0,-176.66667,202.5,109.333336,148.0,
                     -56.0,152.83333,-273.0,-328.0,304.16666,-66.666664,-202.66667,8.333333,69.333336,230.16667,-382.33334,439.66666,-120.0,-41.166668,-157.16667,-263.0,364.33334,-14.833333,212.5,125.666664,-83.166664,
                     -483.16666,-435.0,298.33334,296.0,68.666664,160.33333,14.833333,-143.0,482.16666,-232.0,45.0,8.333333,126.333336,76.666664,234.0,169.16667,252.66667,-81.666664,-278.33334,-460.0,-198.0,
                     -205.16667,169.16667,-310.66666,-374.0,841.5,-25.0,-6.5,-16.0,-183.0,210.0,-425.83334,242.66667,-421.33334,-102.666664,90.666664,-111.0,-278.66666,173.0,-475.83334,-0.6666667,-430.16666,
                     60.333332,50.0,-84.0,-327.0,96.666664,821.5,100.333336,343.33334,204.0,37.5,-248.33333,80.5,114.333336,-99.0,-184.0,320.16666,203.66667,186.66667,-47.333332,-276.0,102.5,
                     -467.66666,210.33333,-326.66666,-70.0,-274.83334,-62.666668,336.33334,-170.5,-447.5,-193.66667,103.666664,132.0,-72.666664,351.0,85.5,353.16666,-103.5,-111.333336,150.0,-189.83333,61.333332,
                     -456.66666,-0.6666667,60.0,175.5,181.66667,462.0,133.66667,161.5,-494.66666,754.0,350.66666,46.833332,-179.83333,-188.0,-330.66666,169.16667,-382.0,195.0,34.666668,-130.0,-23.166666,
                     317.0,379.16666,-89.666664,196.0,54.0,158.16667,125.0,-381.33334,-338.66666,450.66666,285.83334,288.33334,-28.333334,186.66667,-88.666664,-0.16666667,86.666664,-311.66666,-418.66666,-482.83334,175.0,
                     -320.0,-199.33333,58.333332,-59.833332,-163.0,168.0,-8.0,195.0,48.0,45.333332,105.0,-6.8333335,-20.333334,-183.66667,-472.0,-359.66666,436.66666,-90.5,120.333336,-40.666668,131.5,
                     1020.0,241.83333,-2.0,365.33334,40.0,172.66667,-273.33334,41.166668,-297.5,362.83334,-69.833336,113.333336,-301.16666,110.833336,-421.0,-291.0,-23.0,117.0,252.0,-257.66666,-138.83333,
                     50.5,303.33334,288.0,213.83333,28.333334,45.0,111.0,242.33333,286.0,-247.33333,-92.5,-215.5,58.666668,-62.0,-30.833334,238.66667,378.0,-375.33334,-135.5,-223.0,334.16666,
                     -69.0,-217.16667,60.0,-213.33333,285.0,200.16667,-156.0,81.833336,123.333336,217.33333,-198.16667,-189.83333,-136.66667,263.5,37.333332,120.0,164.66667,-379.0,-44.833332,259.0,-154.33333,
                     104.666664,198.33333,-418.16666,-225.0,-251.33333,-429.33334,-56.0,-780.0,29.333334,216.0,130.66667,64.333336,-224.5,22.833334,-131.66667,-264.66666,259.66666,-12.0,-213.33333,-58.333332,-22.5,
                     77.833336,63.166668,-417.33334,-23.833334,-252.33333,315.66666,-456.66666,164.83333,312.0,-423.16666,274.83334,72.5,95.833336,-373.33334,-170.66667,294.66666,367.16666,-144.0,-67.0,-60.0,145.83333,
                     -148.66667,-142.0,-166.5,203.66667,-478.66666,549.0,-334.66666,112.0,-24.0,41.333332,-18.5,-112.833336,149.0,75.833336,506.66666,537.1667,-8.666667,135.0,-149.33333,-294.0,186.33333,
                     389.5,-45.833332,-377.16666,-157.5,78.666664,-355.0,164.5,548.3333,-289.33334,-185.33333,-400.83334,414.0,-155.16667,-969.0,-389.66666,-41.333332,-255.5,-203.5,0.0,-303.66666,-319.16666,
                     241.33333,156.0,238.0,96.666664,1085.0,524.1667,73.0,57.0,-225.0,-22.666666,-109.0,-234.0,-430.0,-320.66666,160.33333,330.66666,-646.0,367.33334,88.833336,484.5,103.5,
                     2.0,68.833336,-273.5,-43.666668,195.5,-231.0,100.0,62.666668,-206.66667,-281.33334,-129.0,105.833336,-341.0,136.33333,-85.333336,156.5,-289.33334,-215.5,128.0,188.83333,76.666664,
                     -1.3333334,151.66667,310.66666,-140.0,171.16667,275.83334,-1.0,385.33334,-15.166667,1073.0,102.666664,-174.33333,306.16666,79.0,296.5,-147.33333,-93.5,40.0,-367.33334,535.0,277.33334,
                     229.0,361.66666,187.66667,213.33333,487.5,-34.666668,-343.0,186.66667,-252.0,-300.66666,331.0,-437.33334,-97.166664,0.0,31.5,-305.5,104.666664,-309.16666,392.83334,86.0,-348.33334
  )
  expected <- array(expected_data, dim = c(21, 21))
  
  expect_equivalent(actual, expected)
})

test_that("attributes are correct", {
  actual <- ncatt_get(file, "lon", "units")$value
  expect_equal(actual, "degrees_east")
  
  actual <- ncatt_get(file, "lon", "long_name")$value
  expect_equal(actual, "longitude")
  
  actual <- ncatt_get(file, "lon", "standard_name")$value
  expect_equal(actual, "longitude")
  
  actual <- ncatt_get(file, "lon", "axis")$value
  expect_equal(actual, "X")
  
  actual <- ncatt_get(file, "lat", "units")$value
  expect_equal(actual, "degrees_north")
  
  actual <- ncatt_get(file, "lat", "long_name")$value
  expect_equal(actual, "latitude")
  
  actual <- ncatt_get(file, "lat", "standard_name")$value
  expect_equal(actual, "latitude")
  
  actual <- ncatt_get(file, "lat", "axis")$value
  expect_equal(actual, "Y")
  
  actual <- ncatt_get(file, "time", "units")$value
  expect_equal(actual, "hours since 1983-01-01 00:00:00")
  
  actual <- ncatt_get(file, "time", "long_name")$value
  expect_equal(actual, "time")
  
  actual <- ncatt_get(file, "time", "standard_name")$value
  expect_equal(actual, "time")
  
  actual <- ncatt_get(file, "time", "calendar")$value
  expect_equal(actual, "standard")
  
  actual <- ncatt_get(file, "SIS", "standard_name")$value
  expect_equal(actual, "SIS_standard")
  
  actual <- ncatt_get(file, "SIS", "long_name")$value
  expect_equal(actual, "Surface Incoming Shortwave Radiation")
  
  actual <- ncatt_get(file, "SIS", "units")$value
  expect_equal(actual, "W m-2")
  
  actual <- ncatt_get(file, "SIS", "_FillValue")$value
  expect_equal(actual, -999)
  
  actual <- ncatt_get(file, "SIS", "cmsaf_info")$value
  expect_equal(actual, "cmsafops::timcovar for variable SIS")
  
  global_attr <- ncatt_get(file, 0)
  expect_equal(length(global_attr), 1)
  
  actual <- names(global_attr[1])
  expect_equal(actual, "Info")
  
  actual <- global_attr[[1]]
  expect_equal(actual, "Created with the CM SAF R Toolbox.")
})

test_that("coordinates are correct", {
  actual <- ncvar_get(file, "lon")
  expect_identical(actual, array(seq(5, 15, 0.5)))
  
  actual <- ncvar_get(file, "lat")
  expect_identical(actual, array(seq(45, 55, 0.5)))
  
  actual <- ncvar_get(file, "time")
  expect_equal(actual, array(151920))
})

nc_close(file)
