% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cmahalanobis.R
\name{chamming}
\alias{chamming}
\title{Calculate the Hamming distance of a factor in a dataframe.}
\usage{
chamming(
  dataset,
  formula,
  plot = TRUE,
  plot_title = "Hamming Distance Between Groups"
)
}
\arguments{
\item{dataset}{A dataframe.}

\item{formula}{The factor which you want to calculate the Hamming distances matrix.}

\item{plot}{If TRUE, shows a plot of the Hamming distances matrix.}

\item{plot_title}{The title of the plot.}
}
\value{
The matrix containing distances.
}
\description{
This function takes a dataframe and a factor in input, and returns a matrix with the Hamming distances about it.
}
\details{
Calculate Hamming distance
}
\examples{

# Example with iris dataset

chamming(iris, ~Species, plot = TRUE, plot_title = "Hamming Distance Between Groups")

# Example with mtcars dataset

chamming(mtcars, ~am, plot = TRUE, plot_title = "Hamming Distance Between Groups")

}
