% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cpa.sw.count.R
\name{cpa.sw.count}
\alias{cpa.sw.count}
\title{Power calculations for stepped-wedge trials with a count outcome.}
\usage{
cpa.sw.count(
  lambda1,
  RR,
  nclusters,
  steps,
  nsubjects,
  ICC = 0.01,
  alpha = 0.05,
  which.var = "within",
  X = NULL,
  all.returned.objects = FALSE
)
}
\arguments{
\item{lambda1}{Baseline rate for outcome of interest}

\item{RR}{Estimated relative risk of the intervention}

\item{nclusters}{Number of clusters}

\item{steps}{Number of time steps. Baseline is assumed.}

\item{nsubjects}{Average size of each cluster}

\item{ICC}{Intra-class correlation coefficient (default = 0.01)}

\item{alpha}{Significance level (default=0.05)}

\item{which.var}{String character specifying which variance to report.
Options are the default value \code{'within'} or \code{'total'}.}

\item{X}{A design matrix indicating the time
at which each of the clusters should switch to the intervention arm. 
Default is NULL and this matrix is automatically computed, but can it can 
be passed as a user-defined matrix with (nclusters) rows and (steps + 1) columns.}

\item{all.returned.objects}{Logical. Default = FALSE, indicating that only the
estimated power should be returned. When TRUE, all objects (listed below) are 
returned.}
}
\value{
\item{power}{ The resulting power } 

When all.returned.objects = TRUE, returned items also include:
\item{sigma.y}{The estimated total (marginal) sd for the outcome} 
\item{sigma.e}{The estimated residual sd} 
\item{sigma.a}{The resulting cluster-level sd} 
\item{setting}{A list including the following values: 
- n.clusters = The number of clusters (nclusters)
- n.time.points = The number of steps in the SW design (steps)
- avg.cluster.size = The average cluster size (nsubjects)
- design.matrix = The design matrix for the SWT under consideration }
}
\description{
This function uses the \code{SWSamp} package by Gianluca Baio for 
estimating power based on analytic formula of Hussey and
Hughes (2007) where sample size calculations are based on 
an assumption of a normally-distributed outcome.
}
\examples{

cpa.sw.count(lambda1 = 1.75, RR = 0.9, nclusters = 21, steps = 6, nsubjects = 30, ICC = 0.01)

}
\references{
Baio, G; Copas, A; Ambler, G; Hargreaves, J; Beard, E; and Omar,
RZ Sample size calculation for a stepped wedge trial. Trials, 16:354. Aug
2015.

Hussey M and Hughes J. Design and analysis of stepped wedge cluster
randomized trials. Contemporary Clinical Trials. 28(2):182-91. Epub 2006 Jul
7. Feb 2007
}
\author{
Alexandria C. Sakrejda (\email{acbro0@umass.edu})

Ken Kleinman (\email{ken.kleinman@gmail.com})
}
