% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Functions.R
\name{goldensearch}
\alias{goldensearch}
\title{Golden Section Search Algorithm}
\usage{
goldensearch(fn, interval, tol = 1)
}
\arguments{
\item{fn}{the function; should be scalar valued}

\item{interval}{a vector containing the lower and upper bounds of search}

\item{tol}{tolerance level for convergence}
}
\value{
a list of objects
\itemize{
\item k: minimiser
\item value: mimimum value
\item iter: number of iterations before convergence
\item iterfn: number of function evaluations
}
}
\description{
Minimising a continuous univariate function using the golden section search algorithm.
}
\examples{
fn = function(x) (x-1)^2; goldensearch(fn=fn,interval=c(-2,3),tol=1)
}
