/*
 * Decompiled with CFR 0.152.
 */
package com.norbl.cbp.ppe;

import com.norbl.cbp.ppe.PPEApp;
import com.norbl.util.ExceptionHandler;
import com.norbl.util.ssh.SshExec;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class HyperthreadDisabler {
    public boolean disable(SshExec ssh, int nCores) {
        try {
            List<Cpu> cpus = this.findCpus(ssh);
            PPEApp.verbose("# HyperthreadDisabler # found n cpus=" + cpus.size() + " nCores=" + nCores);
            if (cpus.size() <= nCores) {
                return false;
            }
            List<Cpu> online = this.getOnlineCpus(cpus);
            PPEApp.verbose("# HyperthreadDisabler # N cpu online=" + online.size());
            int nAccessible = Math.min(cpus.size(), online.size());
            int nToDisable = nAccessible - nCores;
            PPEApp.verbose("# HyperthreadDisabler # N to disable=" + nToDisable);
            if (nToDisable < 1) {
                return false;
            }
            if (nToDisable >= online.size()) {
                PPEApp.verbose("n to disable=" + nToDisable + " but " + " n online=" + online.size() + " soo no disabling.");
                return false;
            }
            Collections.sort(online);
            int idx = online.size() - 1;
            for (int i = 0; i < nToDisable; ++i) {
                this.disableCpu(ssh, online.get(idx));
                --idx;
            }
            return true;
        }
        catch (Exception iox) {
            ExceptionHandler.display(iox);
            return false;
        }
    }

    List<Cpu> findCpus(SshExec ssh) throws IOException {
        String ns = ssh.execRead("sudo ls -1d /sys/devices/system/node/node0/cpu[0123456789]*", 10000L);
        String[] nodeLines = ns.trim().split("\n");
        ArrayList<Cpu> cpus = new ArrayList<Cpu>();
        for (String s : nodeLines) {
            if (!s.startsWith("/sys/devices")) continue;
            cpus.add(new Cpu(s, ssh));
        }
        return cpus;
    }

    List<Cpu> getOnlineCpus(List<Cpu> cpus) {
        ArrayList<Cpu> online = new ArrayList<Cpu>();
        for (Cpu c : cpus) {
            if (!c.isOnline) continue;
            online.add(c);
        }
        return online;
    }

    void disableCpu(SshExec ssh, Cpu cpu) throws IOException {
        ssh.exec("sudo echo 0 > " + cpu.pathToOnline, 10000L);
    }

    class Cpu
    implements Comparable {
        String pathToCpuNumber;
        String pathToOnline;
        int cpuNumber;
        boolean isOnline;

        public Cpu(String line, SshExec ssh) throws IOException {
            this.pathToCpuNumber = line;
            String[] flds = line.split("/");
            String cn = flds[flds.length - 1].trim();
            String ns = cn.substring(3);
            this.cpuNumber = Integer.parseInt(ns);
            String ons = line + "/online";
            String isOn = ssh.execRead("sudo [ -f " + ons + "] && echo 'YES' || echo 'NO'", 10000L);
            if (isOn.equals("YES")) {
                this.isOnline = true;
                this.pathToOnline = ons;
            } else {
                this.isOnline = false;
            }
        }

        public int compareTo(Object other) {
            Cpu o = (Cpu)other;
            if (this.cpuNumber > o.cpuNumber) {
                return 1;
            }
            if (this.cpuNumber < o.cpuNumber) {
                return -1;
            }
            return 0;
        }

        public String toString() {
            return this.pathToOnline + " " + this.cpuNumber + " " + this.isOnline;
        }
    }
}

