/*
 * Decompiled with CFR 0.152.
 */
package com.norbl.cbp.ppe.gui;

import ch.ethz.ssh2.Connection;
import com.norbl.cbp.ppe.ConstantsEc2;
import com.norbl.cbp.ppe.EbsVolumeWrangler;
import com.norbl.cbp.ppe.InstanceStatus;
import com.norbl.cbp.ppe.InstanceTableModel;
import com.norbl.cbp.ppe.PPEManager;
import com.norbl.cbp.ppe.gui.ShowPublicDNSFrame;
import com.norbl.util.ExceptionHandler;
import com.norbl.util.gui.GuiUtil;
import com.norbl.util.ssh.Ssh;
import com.norbl.util.ssh.SshMinimalShell;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTable;

public class InstanceTablePopup
implements ActionListener {
    InstanceTableModel tableModel;
    JTable table;
    ClickHandler clickHandler;
    PPEManager ppeManager;
    EbsVolumeWrangler ebsVolumeWrangler;
    private InstanceStatus instanceStatus;

    public InstanceTablePopup(JTable table, InstanceTableModel tableModel, EbsVolumeWrangler ebsVolumeWrangler) {
        this.table = table;
        this.tableModel = tableModel;
        this.ebsVolumeWrangler = ebsVolumeWrangler;
        this.clickHandler = new ClickHandler();
        table.addMouseListener(this.clickHandler);
    }

    void createPopup(MouseEvent e) {
        JPopupMenu menu = new JPopupMenu("xxxx");
        JMenuItem publicDnsMi = new JMenuItem("Public DNS");
        publicDnsMi.setActionCommand(PopUpCmd.publicDns.toString());
        publicDnsMi.addActionListener(this);
        menu.add(publicDnsMi);
        JMenuItem shellMi = new JMenuItem("Launch shell for this instance");
        shellMi.setActionCommand(PopUpCmd.launchShell.toString());
        shellMi.addActionListener(this);
        menu.add(shellMi);
        JMenu attachVolumeMenu = new JMenu("Attach EBS volume");
        JMenu detachVolumeMenu = new JMenu("Detach EBS volume");
        menu.add(attachVolumeMenu);
        menu.add(detachVolumeMenu);
        this.ebsVolumeWrangler.createAttachMenu(attachVolumeMenu, this.instanceStatus);
        this.ebsVolumeWrangler.createDetachMenu(detachVolumeMenu, this.instanceStatus);
        menu.show(e.getComponent(), e.getX(), e.getY());
    }

    @Override
    public void actionPerformed(ActionEvent ev) {
        if (this.instanceStatus == null) {
            return;
        }
        try {
            PopUpCmd cmd = PopUpCmd.valueOf(ev.getActionCommand());
            switch (cmd) {
                case publicDns: {
                    this.showDns();
                    break;
                }
                case launchShell: {
                    this.launchShell();
                    break;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void showDns() {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                new ShowPublicDNSFrame(InstanceTablePopup.this.instanceStatus);
            }
        });
    }

    void launchShell() {
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    Connection con = Ssh.connect(InstanceTablePopup.this.instanceStatus.getPublicDnsName(), ConstantsEc2.EC2_USERNAME, PPEManager.paramsEc2.rsaKeyPairFile, 600000L);
                    SshMinimalShell shell = new SshMinimalShell(con);
                    shell.connect();
                }
                catch (Exception xxx) {
                    GuiUtil.exceptionMessage(xxx);
                }
            }
        }).start();
    }

    private static enum PopUpCmd {
        publicDns,
        launchShell;

    }

    class CreatePopup
    extends Thread {
        MouseEvent e;

        CreatePopup(MouseEvent e) {
            this.e = e;
        }

        @Override
        public void run() {
            try {
                int idx = InstanceTablePopup.this.table.rowAtPoint(this.e.getPoint());
                if (idx < 0) {
                    return;
                }
                InstanceTablePopup.this.instanceStatus = InstanceTablePopup.this.tableModel.getInstanceStatus(idx);
                if (InstanceTablePopup.this.instanceStatus == null) {
                    return;
                }
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        InstanceTablePopup.this.createPopup(CreatePopup.this.e);
                    }
                });
            }
            catch (Exception xxx) {
                ExceptionHandler.gui(xxx);
            }
        }
    }

    class ClickHandler
    extends MouseAdapter {
        ClickHandler() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            new CreatePopup(e).start();
        }
    }
}

