/*
 * Decompiled with CFR 0.152.
 */
package com.norbl.cbp.ppe.gui;

import com.norbl.cbp.ppe.AmiDescription;
import com.norbl.cbp.ppe.gui.AmiName;
import com.norbl.cbp.ppe.gui.EditTableFrame;
import com.norbl.util.FileUtil;
import com.norbl.util.gui.EditableTableModel;
import com.norbl.util.gui.GuiUtil;
import com.norbl.util.gui.TableModelRowable;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class AmiNameEditor
implements ActionListener {
    private static String OK = "OK";
    private static String CANCEL = "Cancel";
    private static String ADD_ROW = "Add row";
    List<AmiName> amiNames;
    List<TableModelRowable> eiRows;
    EditableTableModel etm;
    EditTableFrame f;

    public void create() {
        try {
            this.amiNames = new ArrayList<AmiName>();
            List<String> names = AmiDescription.getSupportedAmiIDs();
            for (String nm : names) {
                this.amiNames.add(new AmiName(nm));
            }
            this.eiRows = new ArrayList<TableModelRowable>();
            for (AmiName ami : this.amiNames) {
                this.eiRows.add(ami);
            }
            this.etm = new EditableTableModel(this.eiRows);
            this.f = new EditTableFrame("PPE Amazon Machine Images (AMIs)", this.etm, this);
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    AmiNameEditor.this.f.create();
                }
            });
        }
        catch (Exception xx) {
            GuiUtil.exceptionMessage(xx);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String com = e.getActionCommand();
        if (com.equals(OK)) {
            List<TableModelRowable> rows = this.etm.getRows();
            ArrayList<AmiName> amis = new ArrayList<AmiName>();
            for (TableModelRowable r : rows) {
                AmiName ami = (AmiName)r;
                if (ami.name == null || ami.name.length() <= 0) continue;
                amis.add(ami);
            }
            if (amis.size() > 0) {
                this.saveAmis(amis);
            }
            this.f.dispose();
        } else if (com.equals(CANCEL)) {
            this.f.dispose();
        } else if (com.equals(ADD_ROW)) {
            this.etm.addRow(new AmiName(""));
        }
    }

    void saveAmis(List<AmiName> amis) {
        try {
            File backupFile = null;
            File f = AmiDescription.getAmiIDFile();
            if (f.exists() && !f.renameTo(backupFile = FileUtil.getBackupFilename(f))) {
                GuiUtil.warning(new String[]{"Unable to rename " + f.getPath() + "; changes were not saved."}, "File rename error");
                return;
            }
            FileUtil.writeConfigFile(f, this.toLines(amis), " ");
            GuiUtil.info(new String[]{"Updated instance types were written to " + f.getPath(), backupFile != null ? "The old version was saved as " + backupFile.getPath() : ""}, "Updated Ec2 Instance Types");
        }
        catch (IOException iox) {
            GuiUtil.exceptionMessage(iox);
        }
    }

    List<String[]> toLines(List<AmiName> amis) {
        ArrayList<String[]> lines = new ArrayList<String[]>();
        for (AmiName ami : amis) {
            lines.add(new String[]{ami.name});
        }
        return lines;
    }
}

