/*
 * Decompiled with CFR 0.152.
 */
package ppe.gui;

import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.table.TableModel;
import nbl.utilj.EditableTableModel;
import nbl.utilj.GuiUtil;
import nbl.utilj.TableModelRowable;
import ppe.UtilPPE;
import ppe.ec2.Ec2InstanceType;
import ppe.gui.EditTableFrame;

public class InstanceTypeEditor
implements ActionListener {
    private static String OK = "OK";
    private static String CANCEL = "Cancel";
    private static String ADD_ROW = "Add row";
    List<Ec2InstanceType> initialInstanceTypes;
    List<TableModelRowable> eiRows;
    EditableTableModel etm;
    EditTableFrame f;

    public void create() {
        try {
            this.initialInstanceTypes = Ec2InstanceType.getInstanceTypes();
            this.eiRows = new ArrayList<TableModelRowable>();
            for (Ec2InstanceType et : this.initialInstanceTypes) {
                this.eiRows.add(et);
            }
            this.etm = new EditableTableModel(this.eiRows);
            this.f = new EditTableFrame("Ec2 Instance Types", (TableModel)this.etm, this);
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    InstanceTypeEditor.this.f.create();
                }
            });
        }
        catch (Exception xx) {
            GuiUtil.exceptionMessage((Throwable)xx);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String com = e.getActionCommand();
        if (com.equals(OK)) {
            List rows = this.etm.getRows();
            ArrayList<Ec2InstanceType> ets = new ArrayList<Ec2InstanceType>();
            for (TableModelRowable r : rows) {
                Ec2InstanceType eit = (Ec2InstanceType)r;
                if (!eit.isFullySpecified()) continue;
                ets.add(eit);
            }
            if (ets.size() > 0) {
                this.saveInstanceTypes(ets);
            }
            this.f.dispose();
        } else if (com.equals(CANCEL)) {
            this.f.dispose();
        } else if (com.equals(ADD_ROW)) {
            throw new UnsupportedOperationException();
        }
    }

    void saveInstanceTypes(List<Ec2InstanceType> instanceTypes) {
        try {
            File backupFile = null;
            File f = Ec2InstanceType.getInstanceTypeFile();
            if (f.exists() && !f.renameTo(backupFile = UtilPPE.getBackupFilename(f))) {
                GuiUtil.warning((String[])new String[]{"Unable to rename " + f.getPath() + "; changes were not saved."}, (String)"File rename error");
                return;
            }
            UtilPPE.writeConfigFile(f, this.toLines(instanceTypes), " ");
            GuiUtil.info((String[])new String[]{"Updated instance types were written to " + f.getPath(), backupFile != null ? "The old version was saved as " + backupFile.getPath() : ""}, (String)"Updated Ec2 Instance Types");
        }
        catch (IOException iox) {
            GuiUtil.exceptionMessage((Throwable)iox);
        }
    }

    List<String[]> toLines(List<Ec2InstanceType> eits) {
        ArrayList<String[]> lines = new ArrayList<String[]>();
        for (Ec2InstanceType ei : eits) {
            lines.add(new String[]{ei.instanceType.toString(), ei.vt.toString(), Integer.toString(ei.nCores), ei.description});
        }
        return lines;
    }
}

