% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/duration.R
\name{seq.clock_duration}
\alias{seq.clock_duration}
\title{Sequences: duration}
\usage{
\method{seq}{clock_duration}(from, to = NULL, by = NULL, length.out = NULL, along.with = NULL, ...)
}
\arguments{
\item{from}{\verb{[clock_duration(1)]}

A duration to start the sequence from.

\code{from} is always included in the result.}

\item{to}{\verb{[clock_duration(1) / NULL]}

A duration to stop the sequence at.

\code{to} is cast to the type of \code{from}.

\code{to} is only included in the result if the resulting sequence divides
the distance between \code{from} and \code{to} exactly.}

\item{by}{\verb{[integer(1) / clock_duration(1) / NULL]}

The unit to increment the sequence by.

If \code{to < from}, then \code{by} must be positive.

If \code{to > from}, then \code{by} must be negative.

If \code{by} is an integer, it is transformed into a duration with the
precision of \code{from}.

If \code{by} is a duration, it is cast to the type of \code{from}.}

\item{length.out}{\verb{[positive integer(1) / NULL]}

The length of the resulting sequence.

If specified, \code{along.with} must be \code{NULL}.}

\item{along.with}{\verb{[vector / NULL]}

A vector who's length determines the length of the resulting sequence.

Equivalent to \code{length.out = vec_size(along.with)}.

If specified, \code{length.out} must be \code{NULL}.}

\item{...}{These dots are for future extensions and must be empty.}
}
\value{
A sequence with the type of \code{from}.
}
\description{
This is a duration method for the \code{\link[=seq]{seq()}} generic.

Using \code{seq()} on duration objects always retains the type of \code{from}.

When calling \code{seq()}, exactly two of the following must be specified:
\itemize{
\item \code{to}
\item \code{by}
\item Either \code{length.out} or \code{along.with}
}
}
\examples{
seq(duration_days(0), duration_days(100), by = 5)

# Using a duration `by`. Note that `by` is cast to the type of `from`.
seq(duration_days(0), duration_days(100), by = duration_weeks(1))

# `to` is cast from 5 years to 60 months
# `by` is cast from 1 quarter to 4 months
seq(duration_months(0), duration_years(5), by = duration_quarters(1))

seq(duration_days(20), by = 2, length.out = 5)
}
