% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calendar.R
\name{calendar_leap_year}
\alias{calendar_leap_year}
\title{Is the calendar year a leap year?}
\usage{
calendar_leap_year(x)
}
\arguments{
\item{x}{\verb{[calendar]}

A calendar type to detect leap years in.}
}
\value{
A logical vector the same size as \code{x}. Returns \code{TRUE} if in a leap
year, \code{FALSE} if not in a leap year, and \code{NA} if \code{x} is \code{NA}.
}
\description{
\code{calendar_leap_year()} detects if the year is a leap year according to
the Gregorian calendar. It is only relevant for calendar types that use
a Gregorian year, i.e. \code{\link[=year_month_day]{year_month_day()}}, \code{\link[=year_month_weekday]{year_month_weekday()}}, and
\code{\link[=year_day]{year_day()}}.
}
\examples{
x <- year_month_day(c(2019:2024, NA))
calendar_leap_year(x)
}
