% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compareTables.R
\name{compareDiff}
\alias{compareDiff}
\title{Get differences between two data.frames}
\usage{
compareDiff(
  newData,
  oldData,
  referenceVars = intersect(colnames(newData), colnames(oldData)),
  changeableVars = NULL
)
}
\arguments{
\item{newData}{data.frame object representing the new data}

\item{oldData}{data.frame object representing the old data}

\item{referenceVars}{character vector of the columns in the data that are the used as
reference for the comparison. \cr 
If not specified, all columns present both in
\code{newData} and \code{oldData} are considered.}

\item{changeableVars}{character vector of the columns in the data for which you want to assess the change,
e.g. variables that might have changed from the old to the new data.\cr
If not specified, only 'Addition' and 'Removal' are detected.}
}
\value{
Object of class 'diff.data', i.e. a data.frame with columns:
\itemize{
\item{'Comparison type': }{type of difference between
the old and new data, either:
\itemize{
\item{'Change': }{records present both in new and old data,
based on the reference variables, but with difference(s) in changeable vars}
\item{'Addition': }{records with reference variables
present in new but not in old data}
\item{'Removal': }{records with reference variables 
present in old but not in new data}
}}
\item{'Version': }{'Previous' or 'Current' depending if record represents
content from old or new data respectively}
\item{\code{referenceVars}}
\item{\code{changeableVars}}
}
}
\description{
Get differences between two data.frames
}
\section{Identification of the differences between datasets}{

To identify the differences between datasets, the following steps are followed:
\enumerate{
\item{removal of records identical between the old and new dataset
(will be considered as 'Identical' later on)}
\item{records with a reference value present in the old dataset but not
in the new dataset are considered 'Removal'}
\item{records with a reference value present in the new dataset but not
in the old dataset are considered 'Addition'}
\item{records with reference value present both in the new and old dataset,
\strong{after filtering of identical records} and with difference in
the changeable variables are considered 'Change'}
}
}

\author{
Laure Cougnaud
}
