% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reporting-render-html.R
\name{postProcessReport}
\alias{postProcessReport}
\title{Convert clinical data Markdown files to HTML}
\usage{
postProcessReport(
  inputDir = ".",
  configDir = file.path(inputDir, "config"),
  indexPath = file.path(inputDir, "index.Rmd"),
  extraDirs = getExtraDirs(inputDir = inputDir, configDir = configDir),
  outputDir = "./report",
  intermediateDir = "./interim",
  mdFiles = NULL,
  nCores = 1,
  logFile = NULL,
  verbose = TRUE,
  ...
)
}
\arguments{
\item{inputDir}{String with input directory,
working directory by default.}

\item{configDir}{String with directory with config files,
by default a 'config' folder in \code{inputDir}.\cr
It should contain a general 'config.yml' file and dedicated
'config-[X].yml' for each chapter.
The order of each chapter is specified in the 'config' slot in the general 
general 'config.yml'.}

\item{indexPath}{String with path to the index file,
by default 'index.Rmd' in \code{inputDir}.}

\item{extraDirs}{Character vector with extra directories required by
the report, directory with external images.
By default, the directories: 'figures', 'tables' and mentioned in the 
'patientProfilePath' parameter of the
general config file are included.
All these folders should be available in \code{inputDir}.}

\item{outputDir}{String with output directory,
('report' by default).}

\item{intermediateDir}{String with intermediate directory ('interim'
by default), where
markdown files and rds file specifying Js libraries (with \code{knit_meta}) for
each sub report are stored.}

\item{mdFiles}{(optional) Path to the \code{Markdown} files that
should be converted. If specified, the specified config files 
in \code{configDir} are ignored.}

\item{nCores}{Integer containing the number of cores used to render the report
(1 by default). If more than 1, two steps of the report creation are 
run in parallel across chapters: 
\itemize{
\item the rendering of the Rmarkdown file to Markdown
\item the conversion from Markdown to HTML
}}

\item{logFile}{(optional) String with path to a log file,
where output (also error/messages/warnings) should be stored.
If specified, the entire output is re-directed to this file.}

\item{verbose}{Logical, if TRUE (FALSE by default) progress messages are printed
during the report execution.}

\item{...}{Any parameters passed to \code{\link[rmarkdown]{render}},
for expert use only.}
}
\value{
String with path to the front page of the 
report.
}
\description{
Convert clinical data Markdown files to HTML
}
\seealso{
Other clinical data reporting: 
\code{\link{checkReportTitles}()},
\code{\link{forceParams}()},
\code{\link{getMdHeader}()},
\code{\link{getParamsFromConfig}()},
\code{\link{gitbook_clinDataReview_report}()},
\code{\link{html_clinDataReview_report}()},
\code{\link{knitPrintClinDataReview}()},
\code{\link{render_clinDataReviewReport}()}
}
\author{
Laure Cougnaud
}
\concept{clinical data reporting}
