% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reporting-render_clinDataReviewReport.R
\name{forceParams}
\alias{forceParams}
\title{Force the evaluation of the
parameters from config file.}
\usage{
forceParams(params)
}
\arguments{
\item{params}{List of parameters as obtained
via the \code{\link{getParamsFromConfig}}
function.}
}
\value{
Input parameter list, with
object(s) of class \code{r-lazy}
evaluated.
}
\description{
This function is only useful if some
parameters should be lazy-evaluated in the report.
These parameters should have the class: \code{r-lazy}.
A typical use case is a parameter that
consists of a R expression
depending on objects created in a template
report (typically \code{data}).
\cr
Parameters are searched in the environment
in which this function is called from.
}
\examples{
data <- mtcars
params <- list(label = "Cars dataset", nrow = structure("nrow(data)", class = "r-lazy"))
str(params)
str(forceParams(params))
}
\seealso{
\link{getParamsFromConfig}

Other clinical data reporting: 
\code{\link{checkReportTitles}()},
\code{\link{convertMdToHtml}()},
\code{\link{getMdHeader}()},
\code{\link{getParamsFromConfig}()},
\code{\link{gitbook_clinDataReview_report}()},
\code{\link{html_clinDataReview_report}()},
\code{\link{knitPrintClinDataReview}()},
\code{\link{render_clinDataReviewReport}()}
}
\author{
Laure Cougnaud
}
\concept{clinical data reporting}
