% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/return_calcs.R
\name{calc_logReturnProbDiff_fevd}
\alias{calc_logReturnProbDiff_fevd}
\title{Calculates log return probability difference for two sets of covariates and standard error of difference given return value(s) of interest}
\usage{
calc_logReturnProbDiff_fevd(fit, returnValue, covariates1, covariates2,
  getSE = TRUE, scaling = 1)
}
\arguments{
\item{fit}{fitted object from \pkg{extRemes} \code{fevd}}

\item{returnValue}{value(s) for which the log return probability difference is desired}

\item{covariates1}{matrix of covariate values, each row a set of covariates for which the log return probability difference relative to the corresponding row of \code{covariates2} is desired}

\item{covariates2}{matrix of covariate values, each row a set of covariates}

\item{getSE}{logical indicating whether standard error is desired, in addition to the point estimate}

\item{scaling}{if \code{returnValue} is scaled for numerics, this allows names of output to be on original scale}
}
\description{
Calculates difference in log return probabilities for two sets of covariates given return value(s) of interest, using model fit from \code{extRemes::fevd}. Standard error is obtained via the delta method. The return probability is the probability of exceeding the return value in a single block. Differences and standard errors are returned for as many contrasts between covariate sets as provided.
}
\details{
Results are calculated (and returned) on log scale as delta-method based standard errors are more accurate for the log probability. Confidence intervals for the ratio of return probabilities should be calculated by calculating a confidence interval for the log probability difference and exponentiating the endpoints of the interval.

This is designed to calculate differences in log return probabilities and associated standard errors for different covariate values based on the same model fit. It is not designed for differences based on separate model fits, although it may be possible handle this case by fit two models in a single model specification using dummy variables.
}

