% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gen_report.R
\name{gen.report}
\alias{gen.report}
\title{Generate a report.}
\usage{
gen.report(obj)
}
\arguments{
\item{obj}{A \emph{cleanTS} object.}
}
\value{
Does not return any value.
}
\description{
\code{gen.report()} generates a report of the entire process, the changes made
to the original data and details about the impurities found in the data.
}
\examples{
# Convert sunspots.month to dataframe
data <- timetk::tk_tbl(sunspot.month)

# Randomly insert missing values to simulate missing value imputation
set.seed(10)
ind <- sample(nrow(data), 100)
data$value[ind] <- NA

# Perform cleaning
cts <- cleanTS(data, date_format = "my", time = "index", value = "value")

gen.report(cts)

}
