% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/package_search.R
\name{package_search}
\alias{package_search}
\title{Search for packages.}
\usage{
package_search(q = "*:*", fq = NULL, sort = NULL, rows = NULL,
  start = NULL, facet = FALSE, facet.limit = NULL,
  facet.field = NULL, facet.mincount = NULL, include_drafts = FALSE,
  include_private = FALSE, use_default_schema = FALSE,
  url = get_default_url(), key = get_default_key(), as = "list", ...)
}
\arguments{
\item{q}{Query terms, defaults to '*:*', or everything.}

\item{fq}{Filter query, this does not affect the search, only what gets 
returned}

\item{sort}{Field to sort on. You can specify ascending (e.g., score desc) 
or descending (e.g., score asc), sort by two fields (e.g., score desc, 
price asc), or sort by a function (e.g., sum(x_f, y_f) desc, which sorts 
by the sum of x_f and y_f in a descending order).}

\item{rows}{Number of records to return. Defaults to 10.}

\item{start}{Record to start at, default to beginning.}

\item{facet}{(logical) Whether to return facet results or not. 
Default: FALSE}

\item{facet.limit}{(numeric) This param indicates the maximum number of
constraint counts that should be returned for the facet fields.
A negative value means unlimited. Default: 100.
Can be specified on a per field basis.}

\item{facet.field}{(charcter) This param allows you to specify a field which
should be treated as a facet. It will iterate over each Term in the field 
and generate a facet count using that Term as the constraint. This parameter 
can be specified multiple times to indicate multiple facet fields. None of 
the other params in this section will have any effect without specifying at 
least one field name using this param.}

\item{facet.mincount}{(integer) the minimum counts for facet fields should 
be included in the results}

\item{include_drafts}{(logical) if \code{TRUE} draft datasets will be 
included. A user will only be returned their own draft datasets, and a 
sysadmin will be returned all draft datasets. default: \code{FALSE}.
first CKAN version: 2.6.1; dropped from request if CKAN version is older
or if CKAN version isn't available via \code{\link{ckan_version}}}

\item{include_private}{(logical) if \code{TRUE} private datasets will be 
included. Only private datasets from the user’s organizations will be 
returned and sysadmins will be returned all private datasets.
default: \code{FALSE}
first CKAN version: 2.6.1; dropped from request if CKAN version is older
or if CKAN version isn't available via \code{\link{ckan_version}}}

\item{use_default_schema}{(logical) use default package schema instead of a
custom schema defined with an IDatasetForm plugin. default: \code{FALSE}
first CKAN version: 2.3.5; dropped from request if CKAN version is older
or if CKAN version isn't available via \code{\link{ckan_version}}}

\item{url}{Base url to use. Default: \url{http://data.techno-science.ca}. See
also \code{\link{ckanr_setup}} and \code{\link{get_default_url}}.}

\item{key}{A privileged CKAN API key, Default: your key set with \code{\link{ckanr_setup}}}

\item{as}{(character) One of list (default), table, or json. Parsing with table option
uses \code{jsonlite::fromJSON(..., simplifyDataFrame = TRUE)}, which attempts to parse
data to data.frame's when possible, so the result can vary from a vector, list or
data.frame. (required)}

\item{...}{Curl args passed on to \code{\link[httr]{POST}} (optional)}
}
\description{
Search for packages.
}
\examples{
\dontrun{
ckanr_setup(url = "https://demo.ckan.org", key=getOption("ckan_demo_key"))

package_search(q = '*:*')
package_search(q = '*:*', rows = 2, as = 'json')
package_search(q = '*:*', rows = 2, as = 'table')

package_search(q = '*:*', sort = 'score asc')
package_search(q = '*:*', fq = 'num_tags:[3 TO *]')$count
package_search(q = '*:*', fq = 'num_tags:[2 TO *]')$count
package_search(q = '*:*', fq = 'num_tags:[1 TO *]')$count
}
}
