% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generated_client.R
\name{models_list_builds}
\alias{models_list_builds}
\title{List builds for the given model}
\usage{
models_list_builds(
  id,
  limit = NULL,
  page_num = NULL,
  order = NULL,
  order_dir = NULL
)
}
\arguments{
\item{id}{integer required. The ID of the model.}

\item{limit}{integer optional. Number of results to return. Defaults to 20. Maximum allowed is 100.}

\item{page_num}{integer optional. Page number of the results to return. Defaults to the first page, 1.}

\item{order}{string optional. The field on which to order the result set. Defaults to id. Must be one of: id.}

\item{order_dir}{string optional. Direction in which to sort, either asc (ascending) or desc (descending) defaulting to desc.}
}
\value{
An array containing the following fields:
\item{id}{integer, The ID of the model build.}
\item{state}{string, The state of the model build.one of 'queued' 'running' 'succeeded' 'failed' or 'cancelled'.}
\item{error}{string, The error, if any, returned by the build.}
\item{name}{string, The name of the model build.}
\item{createdAt}{string, The time the model build was created.}
\item{description}{string, A description of the model build.}
\item{rootMeanSquaredError}{number, A key metric for continuous models. Nil for other model types.}
\item{rSquaredError}{number, A key metric for continuous models. Nil for other model types.}
\item{rocAuc}{number, A key metric for binary, multinomial, and ordinal models. Nil for other model types.}
\item{transformationMetadata}{string, A string representing the full JSON output of the metadata for transformation of column names}
\item{output}{string, A string representing the JSON output for the specified build. Only present when smaller than 10KB in size.}
\item{outputLocation}{string, A URL representing the location of the full JSON output for the specified build.The URL link will be valid for 5 minutes.}
}
\description{
List builds for the given model
}
