% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generated_client.R
\name{users_get}
\alias{users_get}
\title{Show info about a user}
\usage{
users_get(id)
}
\arguments{
\item{id}{integer required. The ID of this user.}
}
\value{
A list containing the following elements:
\item{id}{integer, The ID of this user.}
\item{user}{string, The username of this user.}
\item{name}{string, The name of this user.}
\item{email}{string, The email of this user.}
\item{active}{string, The account status of this user.}
\item{primaryGroupId}{integer, The ID of the primary group of this user.}
\item{groups}{array, An array containing the following fields: 
\itemize{
\item id integer, The ID of this group.
\item name string, The name of this group.
\item organizationId integer, The organization associated with this group.
}}
\item{city}{string, The city of this user.}
\item{state}{string, The state of this user.}
\item{timeZone}{string, The time zone of this user.}
\item{initials}{string, The initials of this user.}
\item{department}{string, The department of this user.}
\item{title}{string, The title of this user.}
\item{githubUsername}{string, The GitHub username of this user.}
\item{prefersSmsOtp}{string, The preference for phone authorization of this user}
\item{vpnEnabled}{string, The availability of vpn for this user.}
\item{ssoDisabled}{string, The availability of SSO for this user.}
\item{otpRequiredForLogin}{string, The two factor authorization requirement for this user.}
\item{phone}{string, The phone number of this user.}
\item{organizationSlug}{string, The slug of the organization the user belongs to.}
\item{organizationSSODisableCapable}{string, The user's organization's ability to disable sso for their users.}
\item{organizationLoginType}{string, The user's organization's login type.}
}
\description{
Show info about a user
}
