% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/optimizer.R
\name{config_optimizer}
\alias{config_optimizer}
\title{Creation of customized optimizer objects}
\usage{
config_optimizer(
  type = c("adam", "adadelta", "adagrad", "rmsprop", "rprop", "sgd"),
  verbose = FALSE,
  ...
)
}
\arguments{
\item{type}{character string defining which optimizer should be used. See Details.}

\item{verbose}{If TRUE, additional information about scheduler will be printed to console}

\item{...}{additional arguments to be passed to optimizer. See Details.}
}
\value{
object of class cito_optim to give to \code{\link{dnn}}
}
\description{
Helps you create custom optimizer for \code{\link{dnn}}. It is recommended to set learning rate in \code{\link{dnn}}.
}
\details{
different optimizer need different variables, this function will tell you how the variables are set.
For more information see the corresponding functions:
\itemize{
\item adam: \code{\link[torch]{optim_adam}}
\item adadelta: \code{\link[torch]{optim_adadelta}}
\item adagrad: \code{\link[torch]{optim_adagrad}}
\item rmsprop: \code{\link[torch]{optim_rmsprop}}
\item rprop: \code{\link[torch]{optim_rprop}}
\item sgd: \code{\link[torch]{optim_sgd}}
}
}
\examples{
\donttest{
if(torch::torch_is_installed()){
library(cito)

# create optimizer object
opt <- config_optimizer(type = "adagrad",
                        lr_decay = 1e-04,
                        weight_decay = 0.1,
                        verbose = TRUE)

# Build and train  Network
nn.fit<- dnn(Sepal.Length~., data = datasets::iris, optimizer = opt)

}
}
}
