% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/circGLMClassPrintFunctions.R
\name{print.circGLM}
\alias{print.circGLM}
\title{Print circGLM Object}
\usage{
\method{print}{circGLM}(x, type = "text", ...)
}
\arguments{
\item{x}{A \code{circGLM} object to be printed.}

\item{type}{Character string giving the type of printing, such as
\code{"text"}, \code{"mcmc"}, \code{"all"}, \code{"coef"}.}

\item{...}{Additional arguments to be passed to print functions.}
}
\description{
General print function for \code{circGLM} objects, which dispatches the chosen type
of printing to the corresponding function.
}
\examples{
print(circGLM(th = rvmc(10, 1, 1)))

dat <- generateCircGLMData()
cglmmod <- circGLM(th ~ ., dat)

print(cglmmod)

print(cglmmod, type = "mcmc")

print(cglmmod, type = "all")

print(cglmmod, type = "coef")

}
\seealso{
\code{\link{print_text.circGLM}},
  \code{\link{print_mcmc.circGLM}},
  \code{\link{print_all.circGLM}},
  \code{\link{print_coef.circGLM}}.
}
