% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RasterArray-raster.R
\name{calc,RasterArray,function-method}
\alias{calc,RasterArray,function-method}
\title{Calculate method for the RasterArray object}
\usage{
\S4method{calc}{RasterArray,`function`}(x, fun, margin = NULL, na.rm = NULL, forcefun = FALSE, forceapply = FALSE)
}
\arguments{
\item{x}{A RasterArray class object.}

\item{fun}{function to be applied.}

\item{margin}{The \code{MARGIN} parameter of the \code{apply} function. If set to \code{NULL} then the \code{fun} will be applied to the entire stack, producing a single layer.}

\item{na.rm}{Remove NA values, if supported by 'fun' (only relevant when summarizing a multilayer Raster object into a RasterLayer)}

\item{forcefun}{logical. Force calc to not use fun with apply; for use with ambiguous functions and for debugging (see Details)}

\item{forceapply}{logical. Force calc to use fun with apply; for use with ambiguous functions and for debugging (see Details)}
}
\value{
A \code{RasterLayer} or \code{RasterArray class object.}
}
\description{
Calculate values for a new RasterLayer/RasterArray object from another RasterArray object, using a formula.
}
\details{
The method is an extension of the \code{\link[raster]{calc}} function. The strucuture expressed as the RasterArray's dimensions allows the calculations to be iterated for different margins of the array, similarly to the \code{apply} function, controlled by the \code{margin} argument.
}
\examples{
data(dems)

d2 <- cbind(dems, dems)
double <- calc(d2, margin=1, fun=sum)

}
