% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_peaktable.R
\name{mirror_plot}
\alias{mirror_plot}
\title{Make mirror plot from peak table.}
\usage{
mirror_plot(
  peak_table,
  chrom_list,
  lambdas,
  var,
  subset = NULL,
  print_legend = TRUE,
  legend_txt = NULL,
  legend_pos = "topright",
  legend_size = 1,
  mirror = TRUE,
  xlim = NULL,
  ylim = NULL,
  ...
)
}
\arguments{
\item{peak_table}{The peak table (output from \code{\link{get_peaktable}}
function).}

\item{chrom_list}{A list of chromatograms in matrix form (timepoints x
wavelengths).}

\item{lambdas}{The wavelength you wish to plot the traces at.}

\item{var}{Variable to index chromatograms.}

\item{subset}{Character vector specifying levels to use (if more than 2 levels
are present in \code{var}).}

\item{print_legend}{Logical. Whether to print legend. Defaults to \code{TRUE}.}

\item{legend_txt}{Character vector containing labels for legend.}

\item{legend_pos}{Legend position.}

\item{legend_size}{Legend size (\code{cex} argument). Default is 1.}

\item{mirror}{Logical. Whether to plot as mirror or stacked plots.
Defaults to \code{TRUE}.}

\item{xlim}{Numerical vector specifying limits for x axis.}

\item{ylim}{Numerical vector specifying limits for y axis.}

\item{...}{Additional arguments to \code{\link{matplot}} function.}
}
\value{
No return value, called for side effects.
}
\description{
Plots chromatograms as a mirror plot.
}
\details{
Can be used to confirm the identity of a peak or check that a particular
column in the peak table represents a single compound. Can also be used
to create simple box-plots to examine the distribution of a peak with respect
to variables defined in sample metadata.
}
\section{Side effects}{

If \code{mirror_plot} is TRUE, plots a mirror plot comparing two treatments
defined by \code{var} and \code{subset} (if more than two factors are present
in \code{var}).

Otherwise, if \code{mirror_plot} is FALSE, the treatments are plotted in two
separate panes.
}

\examples{
data(Sa_warp)
data(pk_tab)
path <- system.file("extdata", "Sa_metadata.csv", package = "chromatographR")
meta <- read.csv(path)
pk_tab <- attach_metadata(peak_table = pk_tab, metadata = meta, column="vial")
mirror_plot(pk_tab,lambdas=c("210","260"), var="trt", mirror=TRUE, col=c("green","blue"))
}
\author{
Ethan Bass
}
