% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/processing.R
\name{extract_at}
\alias{extract_at}
\alias{extract_at,SpatRaster,sf-method}
\alias{extract_at,character,character-method}
\alias{extract_at,SpatRaster,character-method}
\alias{extract_at,SpatRaster,SpatVector-method}
\alias{extract_at,character,sf-method}
\alias{extract_at,character,SpatVector-method}
\title{Extract raster values with point buffers or polygons}
\usage{
extract_at(x, y, ...)

\S4method{extract_at}{SpatRaster,sf}(
  x = NULL,
  y = NULL,
  id = NULL,
  func = "mean",
  extent = NULL,
  radius = NULL,
  out_class = "sf",
  kernel = NULL,
  kernel_func = stats::weighted.mean,
  bandwidth = NULL,
  max_cells = 3e+07,
  .standalone = TRUE,
  ...
)

\S4method{extract_at}{character,character}(
  x = NULL,
  y = NULL,
  id = NULL,
  func = "mean",
  extent = NULL,
  radius = NULL,
  out_class = "sf",
  kernel = NULL,
  kernel_func = stats::weighted.mean,
  bandwidth = NULL,
  max_cells = 3e+07,
  .standalone = TRUE,
  ...
)

\S4method{extract_at}{SpatRaster,character}(
  x = NULL,
  y = NULL,
  id = NULL,
  func = "mean",
  extent = NULL,
  radius = NULL,
  out_class = "sf",
  kernel = NULL,
  kernel_func = stats::weighted.mean,
  bandwidth = NULL,
  max_cells = 3e+07,
  .standalone = TRUE,
  ...
)

\S4method{extract_at}{SpatRaster,SpatVector}(
  x = NULL,
  y = NULL,
  id = NULL,
  func = "mean",
  extent = NULL,
  radius = NULL,
  out_class = "sf",
  kernel = NULL,
  kernel_func = stats::weighted.mean,
  bandwidth = NULL,
  max_cells = 3e+07,
  .standalone = TRUE,
  ...
)

\S4method{extract_at}{character,sf}(
  x = NULL,
  y = NULL,
  id = NULL,
  func = "mean",
  extent = NULL,
  radius = NULL,
  out_class = "sf",
  kernel = NULL,
  kernel_func = stats::weighted.mean,
  bandwidth = NULL,
  max_cells = 3e+07,
  .standalone = TRUE,
  ...
)

\S4method{extract_at}{character,SpatVector}(
  x = NULL,
  y = NULL,
  id = NULL,
  func = "mean",
  extent = NULL,
  radius = NULL,
  out_class = "sf",
  kernel = NULL,
  kernel_func = stats::weighted.mean,
  bandwidth = NULL,
  max_cells = 3e+07,
  .standalone = TRUE,
  ...
)
}
\arguments{
\item{x}{\code{SpatRaster} object or file path(s) with extensions
that are GDAL-compatible. When multiple file paths are used, the rasters
must have the same extent and resolution.}

\item{y}{\code{sf}/\code{SpatVector} object or file path.}

\item{...}{Placeholder.}

\item{id}{character(1). Unique identifier of each point.}

\item{func}{function taking one numeric vector argument.
Default is \code{"mean"} for all supported signatures in arguments
\code{x} and \code{y}.}

\item{extent}{numeric(4) or SpatExtent. Extent of clipping vector.
It only works with \code{points} of character(1) file path.}

\item{radius}{numeric(1). Buffer radius.}

\item{out_class}{character(1). Output class. One of \code{sf} or \code{terra}.}

\item{kernel}{character(1). Name of a kernel function
One of \code{"uniform"}, \code{"triweight"}, \code{"quartic"}, and \code{"epanechnikov"}}

\item{kernel_func}{function.
Kernel function to apply to the extracted values.
Default is \code{\link[stats:weighted.mean]{stats::weighted.mean()}}}

\item{bandwidth}{numeric(1). Kernel bandwidth.}

\item{max_cells}{integer(1). Maximum number of cells in memory.}

\item{.standalone}{logical(1). Default is \code{TRUE}, which means that
the function will be executed in a standalone mode.
When using this function in \verb{par_*} functions,
set this to \code{FALSE}.}
}
\value{
A data.frame object with summarized raster values with
respect to the mode (polygon or buffer) and the function.
}
\description{
Extract raster values with point buffers or polygons
}
\details{
Inputs are preprocessed in different ways depending on the class.
\itemize{
\item Vector inputs in \code{y}: \code{sf} is preferred, thus character and \code{SpatVector}
inputs will be converted to \code{sf} object. If \code{radius} is not NULL,
\code{sf::st_buffer} is used to generate circular buffers as subsequent
raster-vector overlay is done with \code{exactextractr::exact_extract}.
\item Raster input in \code{x}: \code{SpatRaster} is preferred. If the input is not
\code{SpatRaster}, it will be converted to \code{SpatRaster} object.
}
}
\examples{
ncpath <- system.file("gpkg/nc.gpkg", package = "sf")
rastpath <- file.path(tempdir(), "test.tif")

nc <- terra::vect(ncpath)
nc <- terra::project(nc, "EPSG:5070")
rrast <- terra::rast(nc, nrow = 300, ncol = 660)
terra::values(rrast) <- rgamma(1.98e5, 4, 2)
rpnt <- terra::spatSample(rrast, 16L, as.points = TRUE)
rpnt$pid <- sprintf("ID-\%02d", seq(1, 16))

extract_at(rrast, rpnt, "pid", "mean", radius = 1000)
extract_at(rrast, nc, "NAME", "mean")
extract_at(rrast, ncpath, "NAME", "mean")
# Using SpatRaster object
suppressWarnings(
  extract_at(
    rrast, ncpath, "NAME", "mean",
    kernel = "epanechnikov",
    bandwidth = 1e5
  )
)
# Using raster path
terra::writeRaster(rrast, rastpath, overwrite = TRUE)
suppressWarnings(
  extract_at(
    rastpath, ncpath, "NAME", "mean",
    kernel = "epanechnikov",
    bandwidth = 1e5
  )
)
}
\seealso{
Other Macros for calculation: 
\code{\link{kernelfunction}()},
\code{\link{summarize_aw}()},
\code{\link{summarize_sedc}()}
}
\author{
Insang Song \email{geoissong@gmail.com}
}
\concept{Macros for calculation}
