context("chk-unique")

test_that("vld_unique", {
  expect_true(vld_unique(integer(0)))
  expect_true(vld_unique(NA))
  expect_true(vld_unique(1))
  expect_true(vld_unique(c(1, 2)))
  expect_true(vld_unique(c(1, NA)))
  expect_false(vld_unique(c(NA, NA)))
  expect_true(vld_unique(c(NA, NA), incomparables = NA))
  expect_true(vld_unique(c(NA, NA, 1), incomparables = NA))
  expect_false(vld_unique(c(1, 1)))
  expect_false(vld_unique(c(1, 2, 1)))
})

test_that("chk_unique", {
  expect_null(chk_unique(1))
  expect_invisible(chk_unique(1))
  expect_chk_error(chk_unique(c(1, 1)), "^`c[(]1, 1[)]` must be unique[.]$")
  expect_chk_error(chk_unique(c(1, 1), x_name = "unicorn"), "^Unicorn must be unique[.]$")
})

test_that("vld_unique data frame", {
  data <- data.frame(x = 1:2)
  expect_true(vld_unique(data))
  expect_true(vld_unique(data, incomparables = NA))
  data <- data.frame(x = c(1, 1))
  expect_false(vld_unique(data))
  expect_false(vld_unique(data, incomparables = NA))
  data <- data.frame(y = c(NA, NA))
  expect_true(vld_unique(data, incomparables = NA))
  data <- data.frame(x = 1:2, y = c(NA, NA))
  expect_true(vld_unique(data))
  expect_true(vld_unique(data, incomparables = NA))
  data <- data.frame(x = c(1, 1), y = c(2, 2))
  expect_true(vld_unique(data, incomparables = 2))
  data <- data.frame(x = c(1, 1), y = c(NA, NA))
  expect_true(vld_unique(data, incomparables = NA))
})

test_that("chk_unique data frame", {
  data <- data.frame(x = 1:2)
  expect_null(chk_unique(data))
  expect_invisible(chk_unique(data))
  data <- data.frame(y = c(NA, NA))
  expect_chk_error(chk_unique(data), "^`data` must be unique[.]$")
  data <- data.frame(x = 1:2, y = c(NA, NA))
  data <- data.frame(x = c(1, 1), y = c(2, 2))
  expect_chk_error(chk_unique(data), "^`data` must be unique[.]$")
  data <- data.frame(x = c(1, 1), y = c(NA, NA))
  expect_chk_error(chk_unique(data), "^`data` must be unique[.]$")
})

test_that("vld_named", {
  expect_false(vld_named(list()))
  expect_false(vld_named(list(1)))
  expect_true(vld_named(list(x = 1)))
  expect_true(vld_named(list(x = 1)[-1]))
  expect_true(vld_named(c(x = 1)))
  expect_true(vld_named(c(x = 1)[-1]))
})

test_that("chk_named", {
  expect_null(chk_named(c(x = 1)))
  expect_invisible(chk_named(c(x = 1)))
  expect_chk_error(chk_named(1), "^`1` must be named[.]$")
  expect_chk_error(chk_named(1, x_name = "new born"), "^New born must be named[.]$")
})
